/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.user.relationship;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.ui.web.tag.fn.Functions;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.security.UserManagementActions;
import org.nuxeo.runtime.api.Framework;

@Name(value="userRelationshipActions")
@Scope(value=ScopeType.PAGE)
@Install(precedence=10)
public class UserRelationshipActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(UserRelationshipActions.class);
    public static final String USER_RELATIONSHIP_CHANGED = "UserRelationshipChanged";
    private static final String PUBLICPROFILE_FIELD = "socialprofile:publicprofile";
    @In(create=true)
    protected transient RelationshipService relationshipService;
    @In
    protected transient UserManagementActions userManagementActions;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient NuxeoPrincipal currentUser;
    @In(create=true)
    protected transient UserManager userManager;
    @RequestParameter
    protected String selectedKind;
    @RequestParameter
    protected String selectedUser;
    protected transient ActivityStreamService activityStreamService;
    protected Map<String, List<RelationshipKind>> relationshipsWithUser;
    protected Map<RelationshipKind, Boolean> allRelationshipsState;

    public boolean isAlreadyConnected() {
        return !this.isCurrentUser() && !this.getRelationshipsWithSelectedUser().isEmpty();
    }

    public boolean isAlreadyConnected(String userName) {
        return !this.isCurrentUser(userName) && !this.getRelationshipsWithUser(userName).isEmpty();
    }

    public boolean isCurrentUser() {
        return this.isCurrentUser(this.getSelectedUser());
    }

    public boolean isCurrentUser(String userName) {
        return userName == null || this.getCurrentUser().equals(userName);
    }

    public List<RelationshipKind> getRelationshipsWithUser(String username) {
        if (this.relationshipsWithUser == null) {
            this.relationshipsWithUser = new HashMap<String, List<RelationshipKind>>();
        }
        if (!this.relationshipsWithUser.containsKey(username)) {
            List relations = this.relationshipService.getRelationshipKinds(ActivityHelper.createUserActivityObject((String)this.getCurrentUser()), ActivityHelper.createUserActivityObject((String)username));
            this.relationshipsWithUser.put(username, relations);
        }
        return this.relationshipsWithUser.get(username);
    }

    public List<RelationshipKind> getRelationshipsWithSelectedUser() {
        return this.getRelationshipsWithUser(this.getSelectedUser());
    }

    protected void addRelationshipWithSelectedUser(String userName, String kind) {
        RelationshipKind relationshipKind;
        String selectedUser;
        String currentUser = ActivityHelper.createUserActivityObject((String)this.getCurrentUser());
        if (this.relationshipService.addRelation(currentUser, selectedUser = ActivityHelper.createUserActivityObject((String)userName), relationshipKind = RelationshipKind.fromString((String)kind)).booleanValue()) {
            this.setFacesMessage("label.social.user.relationship.addRelation.success");
            this.addNewRelationActivity(currentUser, selectedUser, relationshipKind);
            Events.instance().raiseEvent(USER_RELATIONSHIP_CHANGED, new Object[0]);
        }
    }

    protected void addNewRelationActivity(String actorActivityObject, String targetActivityObject, RelationshipKind relationshipKind) {
        Activity activity = new ActivityBuilder().actor(actorActivityObject).displayActor(Functions.userFullName((String)ActivityHelper.getUsername((String)actorActivityObject))).verb(relationshipKind.getGroup()).object(targetActivityObject).displayObject(Functions.userFullName((String)ActivityHelper.getUsername((String)targetActivityObject))).build();
        ((ActivityStreamService)Framework.getLocalService(ActivityStreamService.class)).addActivity(activity);
    }

    protected void removeRelationship(String userName, String kind) {
        if (this.relationshipService.removeRelation(ActivityHelper.createUserActivityObject((String)this.getCurrentUser()), ActivityHelper.createUserActivityObject((String)userName), RelationshipKind.fromString((String)kind)).booleanValue()) {
            this.setFacesMessage("label.social.user.relationship.removeRelation.success");
            Events.instance().raiseEvent(USER_RELATIONSHIP_CHANGED, new Object[0]);
        }
    }

    public boolean isActiveRelationship(RelationshipKind relationshipKind) {
        return this.getRelationshipsWithSelectedUser().contains(relationshipKind);
    }

    public Map<RelationshipKind, Boolean> getAllRelationshipsState() throws ClientException {
        if (this.allRelationshipsState == null) {
            this.allRelationshipsState = new HashMap<RelationshipKind, Boolean>();
            for (RelationshipKind kind : this.relationshipService.getRegisteredKinds(null)) {
                this.allRelationshipsState.put(kind, this.isActiveRelationship(kind));
            }
        }
        return this.allRelationshipsState;
    }

    public List<RelationshipKind> getKinds() {
        return this.relationshipService.getRegisteredKinds("circle");
    }

    public List<String> getRelationshipsFromSelectedUser() {
        List targets = this.relationshipService.getTargetsOfKind(ActivityHelper.createUserActivityObject((String)this.getSelectedUser()), RelationshipKind.fromGroup((String)"circle"));
        return ActivityHelper.getUsernames((List)targets);
    }

    public void relationshipCheckboxChanged(ValueChangeEvent event) {
        if (!StringUtils.isBlank((String)this.selectedKind)) {
            if (((Boolean)event.getNewValue()).booleanValue()) {
                this.addRelationshipWithSelectedUser(this.selectedUser, this.selectedKind);
            } else {
                this.removeRelationship(this.selectedUser, this.selectedKind);
            }
        }
    }

    @Observer(value={"UserRelationshipChanged"})
    public void resetUserRelationship() {
        this.relationshipsWithUser = null;
    }

    @Observer(value={"UserRelationshipChanged", "selectedUserChanged"})
    public void resetUserRelationshipStates() {
        this.allRelationshipsState = null;
    }

    protected String getCurrentUser() {
        return this.currentUser.getModel().getId();
    }

    protected String getSelectedUser() {
        DocumentModel selectedUser = this.userManagementActions.getSelectedUser();
        if (selectedUser == null) {
            return null;
        }
        return selectedUser.getId();
    }

    protected void setFacesMessage(String msg) {
        this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get(msg), new Object[0]);
    }

    public boolean canViewProfile(DocumentModel userProfile) {
        try {
            return this.currentUser.isAdministrator() || this.isCurrentUser() || this.isPublicProfile(userProfile) || this.isInCirclesOf(userProfile);
        }
        catch (ClientException e) {
            log.error((Object)"Failed to test profile visibility", (Throwable)e);
            return false;
        }
    }

    protected boolean isPublicProfile(DocumentModel userProfile) throws ClientException {
        Boolean publicProfile = (Boolean)userProfile.getPropertyValue(PUBLICPROFILE_FIELD);
        return publicProfile;
    }

    protected boolean isInCirclesOf(DocumentModel userProfile) throws ClientException {
        String currentUsrActObj = ActivityHelper.createUserActivityObject((Principal)this.currentUser);
        String selectedUsrActObj = ActivityHelper.createUserActivityObject((String)((String)userProfile.getProperty(this.userManager.getUserSchemaName(), this.userManager.getUserIdField())));
        for (RelationshipKind kind : this.getKinds()) {
            List targetsOfKind = this.relationshipService.getTargetsOfKind(selectedUsrActObj, kind);
            if (!targetsOfKind.contains(currentUsrActObj)) continue;
            return true;
        }
        return false;
    }
}

