/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LinterMessageType implements MessageTypeInt
{
    UNUSED_PROVIDE("%s: @provides %s not provided", MessageLevel.ERROR),
    UNUSED_REQUIRE("%s: @requires %s not used", MessageLevel.ERROR),
    LABEL_DOES_NOT_MATCH_LOOP("%s: Unmatched break or continue to label %s", MessageLevel.ERROR),
    RETURN_OUTSIDE_FUNCTION("%s: Return does not appear inside a function", MessageLevel.ERROR),
    UNCAUGHT_THROW_DURING_INIT("%s: Uncaught exception thrown during initialization", MessageLevel.WARNING),
    SYMBOL_NOT_LIVE("%s: Symbol %s may be used before being initialized", MessageLevel.WARNING),
    DUPLICATE_LABEL("%s: Label %s nested inside %s", MessageLevel.ERROR),
    MULTIPLY_PROVIDED_SYMBOL("%s: Another input, %s, already @provides %s", MessageLevel.ERROR),
    OUT_OF_BLOCK_SCOPE("%s: Usage of %s declared at %s is out of block scope.", MessageLevel.ERROR),
    CODE_NOT_REACHABLE("%s: Code is not reachable", MessageLevel.WARNING);

    private final String formatString;
    private final MessageLevel level;
    private final int paramCount;

    private LinterMessageType(String formatString, MessageLevel level) {
        this.formatString = formatString;
        this.level = level;
        this.paramCount = MessageType.formatStringArity(formatString);
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    @Override
    public void format(MessagePart[] parts, MessageContext context, Appendable out) throws IOException {
        MessageType.formatMessage(this.formatString, parts, context, out);
    }

    @Override
    public MessageLevel getLevel() {
        return this.level;
    }
}

