/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.ancillary.jsdoc.HtmlRenderer;
import com.google.caja.ancillary.jsdoc.Jsdoc;
import com.google.caja.ancillary.jsdoc.JsdocException;
import com.google.caja.ancillary.linter.Linter;
import com.google.caja.ancillary.opt.JsOptimizer;
import com.google.caja.ancillary.servlet.CajaWebToolsMessageType;
import com.google.caja.ancillary.servlet.CajaWebToolsServlet;
import com.google.caja.ancillary.servlet.Content;
import com.google.caja.ancillary.servlet.ContentType;
import com.google.caja.ancillary.servlet.Job;
import com.google.caja.ancillary.servlet.LintPage;
import com.google.caja.ancillary.servlet.Request;
import com.google.caja.ancillary.servlet.Resources;
import com.google.caja.ancillary.servlet.UserAgentDb;
import com.google.caja.ancillary.servlet.ZipFileSystem;
import com.google.caja.lang.html.HTML;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.CssTokenType;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.JsLexer;
import com.google.caja.lexer.JsTokenQueue;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Punctuation;
import com.google.caja.lexer.Token;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.TokenQueue;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.css.CssParser;
import com.google.caja.parser.css.CssTree;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.DomParser;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.HtmlQuasiBuilder;
import com.google.caja.parser.html.Namespaces;
import com.google.caja.parser.html.Nodes;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.ObjectConstructor;
import com.google.caja.parser.js.Parser;
import com.google.caja.parser.js.Statement;
import com.google.caja.plugin.CssValidator;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.render.Concatenator;
import com.google.caja.render.CssMinimalPrinter;
import com.google.caja.render.CssPrettyPrinter;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Lists;
import com.google.caja.util.Sets;
import com.google.caja.util.Strings;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Processor {
    private final Request req;
    private final MessageQueue mq;
    private static final Set<MessageTypeInt> IGNORED = Sets.immutableSet(PluginMessageType.DISALLOWED_CSS_PROPERTY_IN_SELECTOR, PluginMessageType.UNSAFE_CSS_PROPERTY, PluginMessageType.UNSAFE_TAG, PluginMessageType.CSS_ATTRIBUTE_TYPE_NOT_ALLOWED_IN_SELECTOR, PluginMessageType.CSS_ATTRIBUTE_NAME_NOT_ALLOWED_IN_SELECTOR, PluginMessageType.CSS_DASHMATCH_ATTRIBUTE_OPERATOR_NOT_ALLOWED, PluginMessageType.IMPORTS_NOT_ALLOWED_HERE, PluginMessageType.FONT_FACE_NOT_ALLOWED);

    Processor(Request req, MessageQueue mq) {
        this.req = req;
        this.mq = mq;
    }

    List<Job> process(List<Job> inputJobs) throws IOException {
        List<Job> jobs = Lists.newArrayList();
        for (Job job : inputJobs) {
            jobs.addAll(this.extractJobs(job));
        }
        if (this.req.lint) {
            this.lint(jobs);
        }
        if (this.req.opt) {
            this.optimize(jobs);
        }
        if (this.req.minify || this.req.opt) {
            this.reincorporateExtracted(jobs);
        }
        List<Job> output = Lists.newArrayList();
        switch (this.req.verb) {
            case DOC: {
                try {
                    output.add(this.doc(jobs, this.req, this.mq));
                }
                catch (JsdocException ex) {
                    ex.toMessageQueue(this.mq);
                }
                break;
            }
            case LINT: {
                output.add(Job.html(LintPage.render(this.reduce(jobs), this.req, this.mq)));
                break;
            }
            default: {
                for (Job job : jobs) {
                    if (job.origin != null) continue;
                    output.add(job);
                }
            }
        }
        Processor.removeCajolerSpecificMessages(this.mq);
        return output;
    }

    Content reduce(List<Job> jobs) {
        ContentType otype = this.req.otype;
        if (otype == null) {
            ContentType commonType = null;
            for (Job job : jobs) {
                if (commonType == null) {
                    commonType = job.t;
                    continue;
                }
                if (commonType == job.t) continue;
                commonType = null;
                break;
            }
            ContentType contentType = otype = commonType != null ? commonType : ContentType.HTML;
        }
        if (otype != ContentType.XML && otype != ContentType.HTML) {
            for (Job job : jobs) {
                if (job.t == otype) continue;
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.INCOMPATIBLE_OUTPUT_TYPE, MessagePart.Factory.valueOf(job.t.name()), MessagePart.Factory.valueOf(otype.name()));
                otype = ContentType.HTML;
                break;
            }
        }
        if (!otype.isText) {
            if (jobs.size() != 1) {
                throw new AssertionError();
            }
            return new Content((byte[])jobs.get((int)0).root, otype);
        }
        StringBuilder outBuf = new StringBuilder();
        RenderContext out = this.makeRenderContext(outBuf, otype);
        switch (otype) {
            case XML: 
            case HTML: {
                HtmlQuasiBuilder b = HtmlQuasiBuilder.getBuilder(DomParser.makeDocument(null, null));
                DocumentFragment f = b.getDocument().createDocumentFragment();
                for (Job job : jobs) {
                    Node toAdd;
                    switch (job.t) {
                        case XML: 
                        case HTML: {
                            toAdd = f.getOwnerDocument().importNode((DocumentFragment)job.root, true);
                            break;
                        }
                        case JS: {
                            StringBuilder sb = new StringBuilder();
                            RenderContext renderContext = this.makeRenderContext(sb, ContentType.JS).withEmbeddable(true);
                            ((Block)job.root).renderBody(renderContext);
                            renderContext.getOut().noMoreTokens();
                            toAdd = b.substV("<script>@js</script>", "js", sb.toString());
                            break;
                        }
                        case CSS: {
                            StringBuilder sb = new StringBuilder();
                            RenderContext renderContext = this.makeRenderContext(sb, ContentType.CSS).withEmbeddable(true);
                            ((CssTree.StyleSheet)job.root).render(renderContext);
                            renderContext.getOut().noMoreTokens();
                            toAdd = b.substV("<style>", "css", sb.toString());
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)job.t.name());
                        }
                    }
                    if (toAdd instanceof DocumentFragment) {
                        for (Node node : Nodes.childrenOf(toAdd)) {
                            f.appendChild(node);
                        }
                        continue;
                    }
                    f.appendChild(toAdd);
                }
                Nodes.render((Node)f, out);
                break;
            }
            case JS: {
                List<? extends Statement> stmts = Lists.newArrayList();
                for (Job job : jobs) {
                    stmts.addAll(((Block)job.root).children());
                }
                new Block(FilePosition.UNKNOWN, stmts).renderBody(out);
                break;
            }
            case JSON: {
                for (Job job : jobs) {
                    ((Expression)job.root).render(out);
                }
                break;
            }
            case CSS: {
                for (Job job : jobs) {
                    ((CssTree.StyleSheet)job.root).render(out);
                }
                break;
            }
            default: {
                throw new AssertionError((Object)otype.name());
            }
        }
        out.getOut().noMoreTokens();
        return new Content(outBuf.toString(), otype);
    }

    Job parse(CharProducer cp, ContentType contentType, Node src) throws ParseException {
        FilePosition inputRange = cp.filePositionForOffsets(cp.getOffset(), cp.getLimit());
        InputSource is = inputRange.source();
        switch (contentType) {
            case XML: 
            case HTML: {
                DomParser p;
                HtmlLexer lexer = new HtmlLexer(cp.clone());
                if (contentType == ContentType.HTML) {
                    Token firstTag = null;
                    while (lexer.hasNext()) {
                        Token t = lexer.next();
                        if (t.type != HtmlTokenType.TAGBEGIN) continue;
                        firstTag = t;
                        break;
                    }
                    p = new DomParser(new HtmlLexer(cp), is, this.mq);
                    if (firstTag != null && Strings.equalsIgnoreCase(firstTag.text, "<html")) {
                        Element el = p.parseDocument();
                        DocumentFragment f = el.getOwnerDocument().createDocumentFragment();
                        f.appendChild(el);
                        return Job.html(f);
                    }
                } else {
                    lexer.setTreatedAsXml(contentType == ContentType.XML);
                    TokenQueue<HtmlTokenType> tq = new TokenQueue<HtmlTokenType>(lexer, is);
                    tq.setInputRange(inputRange);
                    p = new DomParser(tq, contentType == ContentType.XML, this.mq);
                }
                return Job.html(p.parseFragment());
            }
            case JS: {
                JsLexer lexer = new JsLexer(cp);
                JsTokenQueue tq = new JsTokenQueue(lexer, is);
                if (tq.isEmpty()) {
                    return Job.js(new Block(inputRange, Collections.emptyList()), src);
                }
                tq.setInputRange(inputRange);
                Block program = new Parser(tq, this.mq, false).parse();
                tq.expectEmpty();
                return Job.js(program, src);
            }
            case JSON: {
                JsLexer lexer = new JsLexer(cp);
                JsTokenQueue tq = new JsTokenQueue(lexer, is);
                if (!tq.lookaheadToken(Punctuation.LCURLY)) {
                    tq.expectToken(Punctuation.LCURLY);
                }
                tq.setInputRange(inputRange);
                Expression e = new Parser(tq, this.mq, false).parseExpressionPart(true);
                tq.expectEmpty();
                return Job.json((ObjectConstructor)e);
            }
            case CSS: {
                Job job;
                TokenQueue<CssTokenType> tq = CssParser.makeTokenQueue(cp, this.mq, false);
                tq.setInputRange(inputRange);
                CssParser p = new CssParser(tq, this.mq, MessageLevel.WARNING);
                if (src instanceof Attr) {
                    CssTree.DeclarationGroup dg = p.parseDeclarationGroup();
                    job = Job.css(dg, (Attr)src);
                } else {
                    CssTree.StyleSheet ss = p.parseStyleSheet();
                    job = Job.css(ss, (Element)src);
                }
                tq.expectEmpty();
                return job;
            }
        }
        throw new AssertionError((Object)contentType.name());
    }

    RenderContext makeRenderContext(StringBuilder out, ContentType ot) {
        TokenConsumer tc;
        Concatenator cat = new Concatenator(out);
        switch (ot) {
            case XML: 
            case HTML: {
                tc = cat;
                break;
            }
            case CSS: {
                if (this.req.minify) {
                    tc = new CssMinimalPrinter(cat);
                    break;
                }
                tc = new CssPrettyPrinter(cat);
                break;
            }
            case JS: 
            case JSON: {
                if (this.req.minify) {
                    tc = new JsMinimalPrinter(cat);
                    break;
                }
                tc = new JsPrettyPrinter(cat);
                break;
            }
            default: {
                throw new AssertionError((Object)ot.name());
            }
        }
        RenderContext rc = new RenderContext(tc);
        rc = rc.withAsXml(ot == ContentType.XML);
        rc = rc.withAsciiOnly(this.req.asciiOnly);
        rc = rc.withJson(ot == ContentType.JSON);
        rc = rc.withRawObjKeys(this.req.minify);
        return rc;
    }

    private List<Job> extractJobs(Job job) {
        List<Job> all = Lists.newArrayList(job);
        if (job.t == ContentType.XML || job.t == ContentType.HTML) {
            this.extractJobs((Node)job.root, all);
        }
        return all;
    }

    private void extractJobs(Node node, List<Job> out) {
        if (node instanceof Element) {
            Element el = (Element)node;
            ElKey elKey = ElKey.forElement(el);
            if (Namespaces.isHtml(elKey.ns.uri) && ("script".equals(elKey.localName) || "style".equals(elKey.localName))) {
                String mimeType = el.getAttributeNS(elKey.ns.uri, "type");
                boolean bl = "script".equals(elKey.localName);
                if (!bl || !el.hasAttribute("src")) {
                    if ("".equals(mimeType)) {
                        mimeType = bl ? "text/javascript" : "text/css";
                    }
                    CharProducer cp = Processor.cdataProducer(node);
                    try {
                        out.add(this.parse(cp, ContentType.guess(mimeType, null, cp.clone()), el));
                    }
                    catch (ParseException ex) {
                        ex.toMessageQueue(this.mq);
                    }
                }
            }
            for (Attr attr : Nodes.attributesOf(el)) {
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                HTML.Attribute aInfo = this.req.htmlSchema.lookupAttribute(aKey);
                if (aInfo == null) continue;
                HTML.Attribute.Type aType = aInfo.getType();
                switch (aType) {
                    case SCRIPT: 
                    case STYLE: {
                        if ("".equals(attr.getValue().trim())) break;
                        CharProducer cp = this.attribProducer(attr);
                        ContentType ct = aType == HTML.Attribute.Type.SCRIPT ? ContentType.JS : ContentType.CSS;
                        try {
                            out.add(this.parse(cp, ct, attr));
                        }
                        catch (ParseException ex) {
                            ex.toMessageQueue(this.mq);
                        }
                        break;
                    }
                }
            }
        }
        for (Node node2 : Nodes.childrenOf(node)) {
            this.extractJobs(node2, out);
        }
    }

    private static CharProducer cdataProducer(Node node) {
        List<CharProducer> cps = Lists.newArrayList();
        for (Node node2 : Nodes.childrenOf(node)) {
            switch (node2.getNodeType()) {
                case 3: 
                case 4: {
                    cps.add(CharProducer.Factory.fromString((CharSequence)node2.getNodeValue(), Nodes.getFilePositionFor(node2)));
                }
            }
        }
        return CharProducer.Factory.chain(cps.toArray(new CharProducer[0]));
    }

    private CharProducer attribProducer(Attr a) {
        char ch;
        String rawText = Nodes.getRawValue(a);
        FilePosition pos = Nodes.getFilePositionForValue(a);
        int rawTextLen = rawText.length();
        if (rawTextLen >= 2 && ((ch = rawText.charAt(0)) == '\"' || ch == '\'') && ch == rawText.charAt(rawTextLen - 1)) {
            rawText = " " + rawText.substring(1, rawTextLen - 1) + " ";
        }
        return CharProducer.Factory.fromHtmlAttribute(CharProducer.Factory.fromString((CharSequence)rawText, pos));
    }

    private void lint(List<Job> jobs) {
        List<Block> jsJobs = Lists.newArrayList();
        for (Job job : jobs) {
            switch (job.t) {
                case XML: 
                case HTML: {
                    this.lintMarkup((DocumentFragment)job.root);
                    break;
                }
                case CSS: {
                    this.lintCss((CssTree)job.root);
                    break;
                }
                case JS: {
                    jsJobs.add((Block)job.root);
                    break;
                }
                case JSON: {
                    break;
                }
                case ZIP: {
                    throw new IllegalArgumentException();
                }
            }
        }
        this.lintJs(jsJobs);
    }

    private void lintMarkup(Node node) {
        if (node instanceof Element) {
            Element el = (Element)node;
            ElKey elKey = ElKey.forElement(el);
            HTML.Element elInfo = this.req.htmlSchema.lookupElement(elKey);
            if (elInfo == null) {
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.UNKNOWN_ELEMENT, Nodes.getFilePositionFor(el), elKey);
            }
            for (Attr attr : Nodes.attributesOf(el)) {
                FilePosition aPos;
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                HTML.Attribute aInfo = this.req.htmlSchema.lookupAttribute(aKey);
                if (aInfo == null) {
                    aPos = Nodes.getFilePositionFor(attr);
                    this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.UNKNOWN_ATTRIB, aPos, aKey, elKey);
                    continue;
                }
                if (aInfo.getValueCriterion().accept(attr.getValue())) continue;
                aPos = Nodes.getFilePositionForValue(attr);
                this.mq.addMessage((MessageTypeInt)CajaWebToolsMessageType.BAD_ATTRIB_VALUE, aPos, aKey, MessagePart.Factory.valueOf(attr.getValue()));
            }
        }
        for (Node node2 : Nodes.childrenOf(node)) {
            this.lintMarkup(node2);
        }
    }

    private void lintCss(CssTree t) {
        CssValidator v = new CssValidator(this.req.cssSchema, this.req.htmlSchema, this.mq);
        v.validateCss(AncestorChain.instance(t));
    }

    private void lintJs(List<Block> programs) {
        if (programs.isEmpty()) {
            return;
        }
        List<Linter.LintJob> lintJobs = Lists.newArrayList();
        for (Block program : programs) {
            lintJobs.add(Linter.makeLintJob(program, this.mq));
        }
        Linter.lint(lintJobs, Linter.BROWSER_ENVIRONMENT, this.mq);
    }

    private void optimize(List<Job> jobs) {
        ListIterator<Job> jobIt = jobs.listIterator();
        block4: while (jobIt.hasNext()) {
            Job job = jobIt.next();
            switch (job.t) {
                case JS: {
                    job = this.optimizeJs(job);
                    break;
                }
                case HTML: {
                    job = this.optimizeHtml(job);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            jobIt.set(job);
        }
    }

    private Job optimizeJs(Job job) {
        JsOptimizer opt = new JsOptimizer(this.mq);
        opt.addInput((Block)job.root);
        ObjectConstructor envJson = this.req.userAgent != null ? UserAgentDb.lookupEnvJson(this.req.userAgent) : null;
        if (envJson != null) {
            opt.setEnvJson(envJson);
        } else {
            opt.setEnvJson(new ObjectConstructor(FilePosition.UNKNOWN));
        }
        opt.setRename(true);
        Statement optimized = opt.optimize();
        if (!(optimized instanceof Block)) {
            optimized = new Block(optimized.getFilePosition(), Collections.singletonList(optimized));
        }
        return Job.js((Block)optimized, job.origin);
    }

    private Job optimizeHtml(Job job) {
        DocumentFragment f = (DocumentFragment)job.root;
        this.optimizeHtml(f);
        return job;
    }

    private void optimizeHtml(Node n) {
        if (n instanceof Element) {
            Element el = (Element)n;
            ElKey elKey = ElKey.forElement(el);
            List<Attr> toRemove = Lists.newArrayList();
            for (Attr attr : Nodes.attributesOf(el)) {
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                HTML.Attribute aInfo = this.req.htmlSchema.lookupAttribute(aKey);
                if (aInfo == null || !attr.getValue().equals(aInfo.getDefaultValue())) continue;
                toRemove.add(attr);
            }
            for (Attr attr : toRemove) {
                el.removeAttributeNode(attr);
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.optimizeHtml(c);
        }
    }

    private Job doc(List<Job> jobs, Request req, MessageQueue mq) throws IOException, JsdocException {
        Jsdoc jsdoc = new Jsdoc(req.mc, mq);
        for (Job job : jobs) {
            if (job.t != ContentType.JS || job.origin instanceof Attr) continue;
            Block program = (Block)job.root;
            jsdoc.addSource(program);
        }
        try {
            jsdoc.addInitFile("/js/jqueryjs/runtest/env.js", "" + Resources.read(CajaWebToolsServlet.class, "/js/jqueryjs/runtest/env.js"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ObjectConstructor json = jsdoc.extract();
        if (req.otype == ContentType.JSON) {
            return Job.json(json);
        }
        ZipFileSystem fs = new ZipFileSystem("/jsdoc");
        StringBuilder jsonSb = new StringBuilder();
        RenderContext rc = new RenderContext(new JsMinimalPrinter(new Concatenator(jsonSb))).withJson(true);
        json.render(rc);
        rc.getOut().noMoreTokens();
        HtmlRenderer.buildHtml("" + jsonSb, fs, new File("/jsdoc"), req.srcMap.values(), req.mc);
        return fs.toZip();
    }

    private void reincorporateExtracted(List<Job> jobs) {
        Iterator<Job> jobsIt = jobs.iterator();
        while (jobsIt.hasNext()) {
            Node origin;
            Job job = jobsIt.next();
            if (job.origin == null) continue;
            StringBuilder sb = new StringBuilder();
            RenderContext rc = this.makeRenderContext(sb, job.t).withEmbeddable(true);
            if (job.root instanceof Block) {
                ((Block)job.root).renderBody(rc);
            } else {
                ((ParseTreeNode)job.root).render(rc);
            }
            rc.getOut().noMoreTokens();
            String rendered = sb.toString();
            if (job.origin instanceof Element) {
                origin = (Element)job.origin;
                while (origin.getFirstChild() != null) {
                    origin.removeChild(origin.getFirstChild());
                }
                origin.appendChild(origin.getOwnerDocument().createTextNode(rendered));
                jobsIt.remove();
                continue;
            }
            if (!(job.origin instanceof Attr)) continue;
            origin = (Attr)job.origin;
            origin.setNodeValue(rendered);
            jobsIt.remove();
        }
    }

    private static void removeCajolerSpecificMessages(MessageQueue mq) {
        Iterator<Message> i = mq.getMessages().iterator();
        while (i.hasNext()) {
            if (!IGNORED.contains(i.next().getMessageType())) continue;
            i.remove();
        }
    }
}

