/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.render;

import com.google.caja.lexer.FilePosition;
import com.google.caja.render.BufferingRenderer;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsRenderUtil;
import com.google.caja.render.JsTokenAdjacencyChecker;
import com.google.caja.render.TokenClassification;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JsMinimalPrinter
extends BufferingRenderer {
    private int charInLine;
    private int lineLengthLimit = 80;
    private String lastToken;
    private JsTokenAdjacencyChecker adjChecker = new JsTokenAdjacencyChecker();

    public JsMinimalPrinter(Concatenator out) {
        super(out);
    }

    public void setLineLengthLimit(int lineLengthLimit) {
        this.lineLengthLimit = lineLengthLimit;
    }

    @Override
    List<String> splitTokens(List<Object> tokens) {
        ArrayList<String> outputTokens = new ArrayList<String>();
        block3: for (Object tokenEl : tokens) {
            String text;
            TokenClassification tClass;
            if (tokenEl instanceof FilePosition || (tClass = TokenClassification.classify(text = (String)tokenEl)) == null) continue;
            switch (tClass) {
                case LINEBREAK: 
                case SPACE: 
                case COMMENT: {
                    continue block3;
                }
            }
            if (this.adjChecker.needSpaceBefore(text)) {
                if (this.charInLine >= this.lineLengthLimit && JsRenderUtil.canBreakBetween(this.lastToken, text)) {
                    this.charInLine = 0;
                    outputTokens.add("\n");
                } else if (this.charInLine != 0) {
                    ++this.charInLine;
                    outputTokens.add(" ");
                }
            }
            this.charInLine += text.length();
            if ("}".equals(text) && ";".equals(this.lastToken)) {
                outputTokens.set(outputTokens.size() - 1, text);
                this.lastToken = null;
            } else {
                outputTokens.add(text);
            }
            this.lastToken = text;
        }
        if (";".equals(this.lastToken)) {
            outputTokens.remove(outputTokens.size() - 1);
        }
        return outputTokens;
    }
}

