/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.computedgroups.ComputedGroupsService;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.social.relationship.RelationshipKind;
import org.nuxeo.ecm.social.relationship.service.RelationshipService;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.adapters.SubscriptionRequest;
import org.nuxeo.ecm.social.workspace.helper.SocialWorkspaceHelper;
import org.nuxeo.ecm.social.workspace.service.ConfigurationDescriptor;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceContainerDescriptor;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;
import org.nuxeo.ecm.user.invite.UserInvitationService;
import org.nuxeo.ecm.user.invite.UserRegistrationInfo;
import org.nuxeo.ecm.user.registration.DocumentRegistrationInfo;
import org.nuxeo.ecm.user.registration.UserRegistrationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class SocialWorkspaceServiceImpl
extends DefaultComponent
implements SocialWorkspaceService {
    private static final Log log = LogFactory.getLog(SocialWorkspaceServiceImpl.class);
    public static final String CONFIGURATION_EP = "configuration";
    public static final String SOCIAL_WORKSPACE_CONTAINER_EP = "socialWorkspaceContainer";
    public static final String SOCIAL_WORKSPACE_ACL_NAME = "socialWorkspaceAcl";
    public static final String NEWS_ITEMS_ROOT_ACL_NAME = "newsItemsRootAcl";
    public static final String PUBLIC_SOCIAL_WORKSPACE_ACL_NAME = "publicSocialWorkspaceAcl";
    private UserManager userManager;
    private int validationDays;
    private SocialWorkspaceContainerDescriptor socialWorkspaceContainer;
    private RelationshipService relationshipService;
    private ActivityStreamService activityStreamService;

    @Override
    public List<SocialWorkspace> getDetachedPublicSocialWorkspaces(CoreSession session) {
        return this.searchDetachedPublicSocialWorkspaces(session, null);
    }

    @Override
    public List<SocialWorkspace> searchDetachedPublicSocialWorkspaces(CoreSession session, final String pattern) {
        final ArrayList<SocialWorkspace> socialWorkspaces = new ArrayList<SocialWorkspace>();
        UnrestrictedSessionRunner runner = new UnrestrictedSessionRunner(session){
            private static final String ALL_PUBLIC_SOCIAL_WORKSPACE_QUERY = "SELECT * FROM Document WHERE ecm:mixinType != 'HiddenInNavigation' AND ecm:mixinType = '%s' AND ecm:currentLifeCycleState !='deleted' AND socialw:isPublic = 1 ";
            private static final String FULL_TEXT_WHERE_CLAUSE = "AND ecm:fulltext = '%s' ";
            private static final String ORDER_BY = "ORDER BY dc:title";

            public void run() throws ClientException {
                String query = String.format(ALL_PUBLIC_SOCIAL_WORKSPACE_QUERY, "SocialWorkspace");
                if (!StringUtils.isBlank((String)pattern)) {
                    query = String.format(query + FULL_TEXT_WHERE_CLAUSE, pattern);
                }
                query = query + ORDER_BY;
                DocumentModelList docs = this.session.query(query);
                for (DocumentModel doc : docs) {
                    doc.detach(true);
                    socialWorkspaces.add(SocialWorkspaceHelper.toSocialWorkspace(doc));
                }
            }
        };
        try {
            runner.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return socialWorkspaces;
    }

    @Override
    public SocialWorkspace getDetachedSocialWorkspace(DocumentModel doc) {
        return this.getDetachedSocialWorkspace(doc.getCoreSession(), doc.getRef());
    }

    @Override
    public SocialWorkspace getDetachedSocialWorkspace(CoreSession session, DocumentRef docRef) {
        try {
            SocialWorkspaceFinder finder = new SocialWorkspaceFinder(session, docRef);
            finder.runUnrestricted();
            if (finder.socialWorkspace != null) {
                return SocialWorkspaceHelper.toSocialWorkspace(finder.socialWorkspace);
            }
            return null;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public SocialWorkspace getSocialWorkspace(DocumentModel doc) {
        try {
            CoreSession session = doc.getCoreSession();
            if (session != null) {
                List parents = session.getParentDocuments(doc.getRef());
                for (DocumentModel parent : parents) {
                    if (!SocialWorkspaceHelper.isSocialWorkspace(parent)) continue;
                    return SocialWorkspaceHelper.toSocialWorkspace(parent);
                }
            }
            return null;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public int getValidationDays() {
        return this.validationDays;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint)) {
            ConfigurationDescriptor config = (ConfigurationDescriptor)contribution;
            if (config.getValidationTimeInDays() > 0) {
                this.validationDays = config.getValidationTimeInDays();
            }
        } else if (SOCIAL_WORKSPACE_CONTAINER_EP.equals(extensionPoint)) {
            this.socialWorkspaceContainer = (SocialWorkspaceContainerDescriptor)contribution;
        }
    }

    @Override
    public SocialWorkspaceContainerDescriptor getSocialWorkspaceContainerDescriptor() {
        return this.socialWorkspaceContainer;
    }

    @Override
    public DocumentModel getSocialWorkspaceContainer(CoreSession session) {
        try {
            return session.getDocument((DocumentRef)new PathRef(this.socialWorkspaceContainer.getPath()));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void handleSocialWorkspaceCreation(final SocialWorkspace socialWorkspace, Principal principal) {
        this.createBaseRelationshipsWithSocialWorkspace(socialWorkspace, principal);
        CoreSession session = socialWorkspace.getDocument().getCoreSession();
        try {
            new UnrestrictedSessionRunner(session){

                public void run() throws ClientException {
                    SocialWorkspace unrestrictedSocialWorkspace = SocialWorkspaceHelper.toSocialWorkspace(this.session.getDocument((DocumentRef)new IdRef(socialWorkspace.getId())));
                    SocialWorkspaceServiceImpl.this.initializeSocialWorkspaceRights(unrestrictedSocialWorkspace);
                    SocialWorkspaceServiceImpl.initializeNewsItemsRootRights(unrestrictedSocialWorkspace);
                    if (unrestrictedSocialWorkspace.isPublic()) {
                        SocialWorkspaceServiceImpl.this.makeSocialWorkspacePublic(unrestrictedSocialWorkspace);
                    }
                }
            }.runUnrestricted();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void createBaseRelationshipsWithSocialWorkspace(SocialWorkspace socialWorkspace, Principal principal) {
        this.addSocialWorkspaceAdministrator(socialWorkspace, principal);
        ((NuxeoPrincipal)principal).getAllGroups().add(socialWorkspace.getAdministratorsGroupName());
    }

    @Override
    public void handleSocialWorkspaceDeletion(SocialWorkspace socialWorkspace) {
        this.getRelationshipService().removeRelation(socialWorkspace.getId(), null, SocialWorkspaceHelper.buildRelationKind());
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                this.userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        return this.userManager;
    }

    private void initializeSocialWorkspaceRights(SocialWorkspace socialWorkspace) {
        try {
            DocumentModel doc = socialWorkspace.getDocument();
            CoreSession session = doc.getCoreSession();
            ACP acp = doc.getACP();
            ACL acl = acp.getOrCreateACL(SOCIAL_WORKSPACE_ACL_NAME);
            this.addSocialWorkspaceACL(acl, socialWorkspace);
            doc.setACP(acp, true);
            doc.putContextData(ScopeType.REQUEST, "doNotProcess", (Serializable)Boolean.valueOf(true));
            doc = session.saveDocument(doc);
            socialWorkspace.setDocument(doc);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void addSocialWorkspaceACL(ACL acl, SocialWorkspace socialWorkspace) {
        this.addEverythingForAdministratorsACE(acl);
        acl.add((Object)new ACE(socialWorkspace.getAdministratorsGroupName(), "Everything", true));
        acl.add((Object)new ACE(socialWorkspace.getMembersGroupName(), "ReadWrite", true));
        acl.add((Object)new ACE("Everyone", "Everything", false));
    }

    private void addEverythingForAdministratorsACE(ACL acl) {
        for (String adminGroup : this.getUserManager().getAdministratorsGroups()) {
            acl.add((Object)new ACE(adminGroup, "Everything", true));
        }
    }

    private static void initializeNewsItemsRootRights(SocialWorkspace socialWorkspace) {
        try {
            CoreSession session = socialWorkspace.getDocument().getCoreSession();
            PathRef newsItemsRootPath = new PathRef(socialWorkspace.getNewsItemsRootPath());
            DocumentModel newsItemsRoot = session.getDocument((DocumentRef)newsItemsRootPath);
            ACP acp = newsItemsRoot.getACP();
            ACL acl = acp.getOrCreateACL(NEWS_ITEMS_ROOT_ACL_NAME);
            acl.add((Object)new ACE(socialWorkspace.getAdministratorsGroupName(), "Everything", true));
            acl.add((Object)new ACE(socialWorkspace.getMembersGroupName(), "Write", false));
            newsItemsRoot.setACP(acp, true);
            session.saveDocument(newsItemsRoot);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean addSocialWorkspaceAdministrator(SocialWorkspace socialWorkspace, Principal principal) {
        if (this.addPrincipalToSocialWorkspace(ActivityHelper.createUserActivityObject((String)principal.getName()), ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument()), SocialWorkspaceHelper.buildRelationAdministratorKind())) {
            this.addSocialWorkspaceMember(socialWorkspace, principal);
            this.updatePrincipalGroups(principal);
            return true;
        }
        return false;
    }

    @Override
    public boolean addSocialWorkspaceMember(SocialWorkspace socialWorkspace, Principal principal) {
        Boolean memberCreated = this.addSocialWorkspaceMemberWithoutNotification(socialWorkspace, principal);
        if (memberCreated.booleanValue()) {
            this.updatePrincipalGroups(principal);
            SocialWorkspaceServiceImpl.fireEventMembersManagement(socialWorkspace, Arrays.asList(principal), "newMembersAdded");
        }
        return memberCreated;
    }

    private void updatePrincipalGroups(Principal principal) {
        if (principal instanceof NuxeoPrincipalImpl) {
            NuxeoPrincipalImpl nuxeoPrincipal = (NuxeoPrincipalImpl)principal;
            ComputedGroupsService computedGroupsService = (ComputedGroupsService)Framework.getLocalService(ComputedGroupsService.class);
            computedGroupsService.updateGroupsForUser(nuxeoPrincipal);
        }
    }

    private boolean addSocialWorkspaceMemberWithoutNotification(SocialWorkspace socialWorkspace, Principal principal) {
        if (this.addPrincipalToSocialWorkspace(ActivityHelper.createUserActivityObject((String)principal.getName()), ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument()), SocialWorkspaceHelper.buildRelationMemberKind())) {
            this.addNewActivity(principal, socialWorkspace, SocialWorkspaceHelper.buildRelationMemberKind());
            return true;
        }
        return false;
    }

    @Override
    public List<String> addSocialWorkspaceMembers(SocialWorkspace socialWorkspace, String groupName) throws ClientException {
        NuxeoGroup group = this.getUserManager().getGroup(groupName);
        if (group == null) {
            throw new ClientException(String.format("Group (%s) not found", groupName));
        }
        ArrayList<String> importedUsers = new ArrayList<String>();
        ArrayList<Principal> importedPrincipal = new ArrayList<Principal>();
        for (String userName : group.getMemberUsers()) {
            NuxeoPrincipal principal = this.userManager.getPrincipal(userName);
            if (principal == null) {
                log.info((Object)String.format("User (%s) doesn't exist.", userName));
                continue;
            }
            if (!socialWorkspace.shouldRequestSubscription((Principal)principal)) continue;
            this.handleSubscriptionRequest(socialWorkspace, (Principal)principal, true);
            importedUsers.add(userName);
            importedPrincipal.add((Principal)principal);
        }
        SocialWorkspaceServiceImpl.fireEventMembersManagement(socialWorkspace, importedPrincipal, "newMembersAdded");
        return importedUsers;
    }

    @Override
    public List<String> addSocialWorkspaceMembers(SocialWorkspace socialWorkspace, List<String> emails) throws ClientException {
        ArrayList<String> memberAddedList = new ArrayList<String>(emails.size());
        ArrayList<Principal> principalAdded = new ArrayList<Principal>();
        for (String email : emails) {
            NuxeoPrincipal principal;
            HashMap<String, String> filter = new HashMap<String, String>();
            String emailKey = this.getUserManager().getUserEmailField();
            filter.put(emailKey, email);
            HashSet<String> pattern = new HashSet<String>();
            pattern.add(emailKey);
            DocumentModelList foundUsers = this.userManager.searchUsers(filter, pattern);
            if (foundUsers.isEmpty()) continue;
            if (foundUsers.size() > 1) {
                log.info((Object)("For the email " + email + " several user were found. First one used."));
            }
            if (!socialWorkspace.shouldRequestSubscription((Principal)(principal = this.userManager.getPrincipal(((DocumentModel)foundUsers.get(0)).getId())))) continue;
            this.handleSubscriptionRequest(socialWorkspace, (Principal)principal, true);
            memberAddedList.add(email);
            principalAdded.add((Principal)principal);
        }
        SocialWorkspaceServiceImpl.fireEventMembersManagement(socialWorkspace, principalAdded, "newMembersAdded");
        return memberAddedList;
    }

    private void addNewActivity(Principal principal, SocialWorkspace socialWorkspace, RelationshipKind kind) {
        ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getLocalService(ActivityStreamService.class);
        Activity activity = this.createActivity(principal, socialWorkspace, kind, false);
        activityStreamService.addActivity(activity);
        activity = this.createActivity(principal, socialWorkspace, kind, true);
        activityStreamService.addActivity(activity);
    }

    private Activity createActivity(Principal principal, SocialWorkspace socialWorkspace, RelationshipKind kind, boolean addContext) {
        String socialWorkspaceActivityObject = ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument());
        return new ActivityBuilder().actor(ActivityHelper.createUserActivityObject((String)principal.getName())).displayActor(ActivityHelper.generateDisplayName((Principal)principal)).verb(kind.toString()).object(ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument())).displayObject(socialWorkspace.getTitle()).target(socialWorkspaceActivityObject).displayTarget(socialWorkspace.getTitle()).context(addContext ? socialWorkspaceActivityObject : null).build();
    }

    @Override
    public void removeSocialWorkspaceAdministrator(SocialWorkspace socialWorkspace, Principal principal) {
        this.removePrincipalFromSocialWorkspace(ActivityHelper.createUserActivityObject((String)principal.getName()), ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument()), SocialWorkspaceHelper.buildRelationAdministratorKind());
    }

    @Override
    public void removeSocialWorkspaceMember(SocialWorkspace socialWorkspace, Principal principal) {
        if (this.removePrincipalFromSocialWorkspace(ActivityHelper.createUserActivityObject((String)principal.getName()), ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument()), SocialWorkspaceHelper.buildRelationMemberKind())) {
            SocialWorkspaceServiceImpl.fireEventMembersManagement(socialWorkspace, Arrays.asList(principal), "newMembersRemoved");
        }
    }

    private boolean addPrincipalToSocialWorkspace(String principalName, String socialWorkspaceId, RelationshipKind kind) {
        boolean added = this.getRelationshipService().addRelation(principalName, socialWorkspaceId, kind);
        return added &= this.getRelationshipService().addRelation(socialWorkspaceId, principalName, kind).booleanValue();
    }

    private boolean removePrincipalFromSocialWorkspace(String principalName, String socialWorkspaceId, RelationshipKind kind) {
        boolean removed = this.getRelationshipService().removeRelation(principalName, socialWorkspaceId, kind);
        return removed |= this.getRelationshipService().removeRelation(socialWorkspaceId, principalName, kind).booleanValue();
    }

    @Override
    public void makeSocialWorkspacePublic(SocialWorkspace socialWorkspace) {
        try {
            DocumentModel doc = socialWorkspace.getDocument();
            doc.setPropertyValue("socialw:isPublic", (Serializable)Boolean.valueOf(true));
            doc.putContextData(ScopeType.REQUEST, "doNotProcess", (Serializable)Boolean.valueOf(true));
            CoreSession session = doc.getCoreSession();
            this.makePublicSectionReadable(session, socialWorkspace);
            this.makePublicDashboardReadable(session, socialWorkspace);
            doc = session.saveDocument(doc);
            session.save();
            socialWorkspace.setDocument(doc);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void makePublicSectionReadable(CoreSession session, SocialWorkspace socialWorkspace) throws ClientException {
        PathRef publicSectionRef = new PathRef(socialWorkspace.getPublicSectionPath());
        DocumentModel publicSection = session.getDocument((DocumentRef)publicSectionRef);
        ACP acp = publicSection.getACP();
        ACL acl = acp.getOrCreateACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        acl.clear();
        this.addReadForDefaultGroup(acl);
        publicSection.setACP(acp, true);
        session.saveDocument(publicSection);
    }

    private void addReadForDefaultGroup(ACL acl) {
        String defaultGroup = this.getUserManager().getDefaultGroup();
        defaultGroup = defaultGroup == null ? "Everyone" : defaultGroup;
        acl.add((Object)new ACE(defaultGroup, "Read", true));
    }

    private void makePublicDashboardReadable(CoreSession session, SocialWorkspace socialWorkspace) throws ClientException {
        PathRef dashboardSpacesRootRef = new PathRef(socialWorkspace.getDashboardSpacesRootPath());
        DocumentModel dashboardSpacesRoot = session.getDocument((DocumentRef)dashboardSpacesRootRef);
        ACP acp = dashboardSpacesRoot.getACP();
        ACL acl = acp.getOrCreateACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        acl.clear();
        this.addReadForDefaultGroup(acl);
        dashboardSpacesRoot.setACP(acp, true);
        session.saveDocument(dashboardSpacesRoot);
        PathRef privateDashboardSpaceRef = new PathRef(socialWorkspace.getPrivateDashboardSpacePath());
        DocumentModel privateDashboardSpace = session.getDocument((DocumentRef)privateDashboardSpaceRef);
        acp = privateDashboardSpace.getACP();
        acl = acp.getOrCreateACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        this.addSocialWorkspaceACL(acl, socialWorkspace);
        privateDashboardSpace.setACP(acp, true);
        session.saveDocument(privateDashboardSpace);
    }

    @Override
    public void makeSocialWorkspacePrivate(SocialWorkspace socialWorkspace) {
        try {
            DocumentModel doc = socialWorkspace.getDocument();
            doc.setPropertyValue("socialw:isPublic", (Serializable)Boolean.valueOf(false));
            doc.putContextData(ScopeType.REQUEST, "doNotProcess", (Serializable)Boolean.valueOf(true));
            CoreSession session = doc.getCoreSession();
            SocialWorkspaceServiceImpl.makePublicSectionUnreadable(session, socialWorkspace);
            SocialWorkspaceServiceImpl.makePublicDashboardUnreadable(session, socialWorkspace);
            doc = session.saveDocument(doc);
            session.save();
            socialWorkspace.setDocument(doc);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private static void makePublicSectionUnreadable(CoreSession session, SocialWorkspace socialWorkspace) throws ClientException {
        PathRef publicSectionRef = new PathRef(socialWorkspace.getPublicSectionPath());
        DocumentModel publicSection = session.getDocument((DocumentRef)publicSectionRef);
        ACP acp = publicSection.getACP();
        acp.removeACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        publicSection.setACP(acp, true);
        session.saveDocument(publicSection);
    }

    private static void fireEventMembersManagement(SocialWorkspace socialWorkspace, List<Principal> usernames, String eventName) {
        if (socialWorkspace.isMembersNotificationEnabled()) {
            DocumentModel doc = socialWorkspace.getDocument();
            DocumentEventContext ctx = new DocumentEventContext(doc.getCoreSession(), doc.getCoreSession().getPrincipal(), doc);
            ctx.setProperty("socialWorkspacePrincipals", (Serializable)((Object)usernames));
            try {
                ((EventService)Framework.getLocalService(EventService.class)).fireEvent(ctx.newEvent(eventName));
            }
            catch (ClientException e) {
                log.warn((Object)"Unable to notify social workspace members", (Throwable)e);
            }
        }
    }

    private static void makePublicDashboardUnreadable(CoreSession session, SocialWorkspace socialWorkspace) throws ClientException {
        PathRef dashboardSpacesRootRef = new PathRef(socialWorkspace.getDashboardSpacesRootPath());
        DocumentModel dashboardSpacesRoot = session.getDocument((DocumentRef)dashboardSpacesRootRef);
        ACP acp = dashboardSpacesRoot.getACP();
        acp.removeACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        dashboardSpacesRoot.setACP(acp, true);
        session.saveDocument(dashboardSpacesRoot);
        PathRef privateDashboardSpaceRef = new PathRef(socialWorkspace.getPrivateDashboardSpacePath());
        DocumentModel privateDashboardSpace = session.getDocument((DocumentRef)privateDashboardSpaceRef);
        acp = privateDashboardSpace.getACP();
        acp.removeACL(PUBLIC_SOCIAL_WORKSPACE_ACL_NAME);
        privateDashboardSpace.setACP(acp, true);
        session.saveDocument(privateDashboardSpace);
    }

    @Override
    public void handleSubscriptionRequest(SocialWorkspace socialWorkspace, Principal principal) {
        this.handleSubscriptionRequest(socialWorkspace, principal, !socialWorkspace.mustApproveSubscription());
    }

    protected void handleSubscriptionRequest(SocialWorkspace socialWorkspace, Principal principal, boolean autoAccept) {
        UserRegistrationInfo userInfo = this.buildUserRegistrationInfo(socialWorkspace, (NuxeoPrincipal)principal);
        DocumentRegistrationInfo docInfo = this.buildDocumentRegistrationInfo(socialWorkspace);
        HashMap additionalInfo = new HashMap();
        try {
            this.getRegistrationService().submitRegistrationRequest("social_collaboration", userInfo, docInfo, additionalInfo, UserInvitationService.ValidationMethod.EMAIL, autoAccept, principal.getName());
        }
        catch (ClientException e) {
            log.warn((Object)"Unable to submit social registration", (Throwable)e);
        }
    }

    private DocumentRegistrationInfo buildDocumentRegistrationInfo(SocialWorkspace socialWorkspace) {
        DocumentRegistrationInfo docInfo = new DocumentRegistrationInfo();
        docInfo.setDocumentId(socialWorkspace.getId());
        docInfo.setDocumentTitle(socialWorkspace.getTitle());
        return docInfo;
    }

    private UserRegistrationInfo buildUserRegistrationInfo(SocialWorkspace socialWorkspace, NuxeoPrincipal principal) {
        UserRegistrationInfo userInfo = new UserRegistrationInfo();
        userInfo.setLogin(principal.getName());
        userInfo.setEmail(principal.getEmail());
        userInfo.setFirstName(principal.getFirstName());
        userInfo.setLastName(principal.getLastName());
        userInfo.setCompany(principal.getCompany());
        return userInfo;
    }

    @Override
    public boolean isSubscriptionRequestPending(SocialWorkspace socialWorkspace, Principal principal) {
        log.warn((Object)"Deprecated call to org.nuxeo.ecm.social.workspace.service.SocialWorkspaceServiceImpl#getSubscriptionRequestStatus");
        return false;
    }

    @Override
    public String getSubscriptionRequestStatus(SocialWorkspace socialWorkspace, Principal principal) {
        DocumentModelList docs = null;
        try {
            docs = this.getRegistrationService().getRegistrationsForUser(socialWorkspace.getId(), principal.getName(), "social_collaboration");
            if (docs.size() > 0) {
                return ((DocumentModel)docs.get(0)).getCurrentLifeCycleState();
            }
        }
        catch (ClientException e) {
            log.warn((Object)e, (Throwable)e);
        }
        return null;
    }

    @Override
    public void acceptSubscriptionRequest(SocialWorkspace socialWorkspace, SubscriptionRequest subscriptionRequest) {
        log.warn((Object)"Deprecated call to org.nuxeo.ecm.social.workspace.service.SocialWorkspaceServiceImpl#acceptSubscriptionRequest");
    }

    @Override
    public void rejectSubscriptionRequest(SocialWorkspace socialWorkspace, SubscriptionRequest subscriptionRequest) {
        log.warn((Object)"Deprecated call to org.nuxeo.ecm.social.workspace.service.SocialWorkspaceServiceImpl#rejectSubscriptionRequest");
    }

    @Override
    public List<String> searchUsers(SocialWorkspace socialWorkspace, RelationshipKind kind, String pattern) {
        List targets = this.getRelationshipService().getTargetsWithFulltext(ActivityHelper.createDocumentActivityObject((DocumentModel)socialWorkspace.getDocument()), kind, pattern);
        ArrayList<String> users = new ArrayList<String>();
        for (String target : targets) {
            users.add(ActivityHelper.getUsername((String)target));
        }
        return users;
    }

    @Override
    public List<String> searchMembers(SocialWorkspace socialWorkspace, String pattern) {
        List<String> list = this.searchUsers(socialWorkspace, SocialWorkspaceHelper.buildRelationMemberKind(), null);
        return this.filterUsers(pattern, list);
    }

    @Override
    public List<String> searchAdministrators(SocialWorkspace socialWorkspace, String pattern) {
        List<String> list = this.searchUsers(socialWorkspace, SocialWorkspaceHelper.buildRelationAdministratorKind(), null);
        return this.filterUsers(pattern, list);
    }

    private List<String> filterUsers(String pattern, List<String> validNames) {
        ArrayList<String> members = new ArrayList<String>();
        DocumentModelList users = null;
        try {
            users = this.getUserManager().searchUsers(pattern);
        }
        catch (ClientException e) {
            log.warn((Object)("failed to get users that match pattern:" + pattern), (Throwable)e);
        }
        if (users != null) {
            for (DocumentModel user : users) {
                try {
                    String name = (String)user.getProperty(this.getUserManager().getUserSchemaName(), this.getUserManager().getUserIdField());
                    if (!validNames.contains(name)) continue;
                    members.add(name);
                }
                catch (PropertyException e) {
                    log.debug((Object)e, (Throwable)e);
                }
                catch (ClientException e) {
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
        return members;
    }

    private RelationshipService getRelationshipService() {
        if (this.relationshipService == null) {
            try {
                this.relationshipService = (RelationshipService)Framework.getService(RelationshipService.class);
            }
            catch (Exception e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
        if (this.relationshipService == null) {
            throw new ClientRuntimeException("RelationshipService is not registered.");
        }
        return this.relationshipService;
    }

    private UserRegistrationService getRegistrationService() {
        return (UserRegistrationService)Framework.getLocalService(UserRegistrationService.class);
    }

    private static class SocialWorkspaceFinder
    extends UnrestrictedSessionRunner {
        private final DocumentRef docRef;
        public DocumentModel socialWorkspace;

        protected SocialWorkspaceFinder(CoreSession session, DocumentRef docRef) {
            super(session);
            this.docRef = docRef;
        }

        public void run() throws ClientException {
            List parents = this.session.getParentDocuments(this.docRef);
            for (DocumentModel parent : parents) {
                if (!SocialWorkspaceHelper.isSocialWorkspace(parent)) continue;
                this.socialWorkspace = parent;
                this.socialWorkspace.detach(true);
                if (!(this.socialWorkspace instanceof DocumentModelImpl)) continue;
                break;
            }
        }
    }
}

