/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.social.workspace.gadgets;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.nuxeo.ecm.activity.ActivityMessage;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.InputStreamBlob;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.social.workspace.adapters.SocialWorkspace;
import org.nuxeo.ecm.social.workspace.gadgets.SocialWorkspaceActivityStreamPageProvider;
import org.nuxeo.ecm.social.workspace.service.SocialWorkspaceService;

@Operation(id="Services.GetSocialWorkspaceActivityStream", category="Services", label="Get a social workspace activity stream", description="Get a social workspace activity stream.")
public class GetSocialWorkspaceActivityStream {
    public static final String ID = "Services.GetSocialWorkspaceActivityStream";
    public static final String PROVIDER_NAME = "social_workspace_activity_stream";
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService pageProviderService;
    @Context
    protected SocialWorkspaceService socialWorkspaceService;
    @Param(name="contextPath", required=true)
    protected String contextPath;
    @Param(name="language", required=false)
    protected String language;
    @Param(name="activityLinkBuilder", required=true)
    protected String activityLinkBuilder;
    @Param(name="offset", required=false)
    protected Integer offset;
    @Param(name="limit", required=false)
    protected Integer limit;

    @OperationMethod
    public Blob run() throws Exception {
        Long targetOffset = 0L;
        if (this.offset != null) {
            targetOffset = this.offset.longValue();
        }
        Long targetLimit = null;
        if (this.limit != null) {
            targetLimit = this.limit.longValue();
        }
        SocialWorkspace socialWorkspace = this.socialWorkspaceService.getDetachedSocialWorkspace(this.session, (DocumentRef)new PathRef(this.contextPath));
        Locale locale = this.language != null && !this.language.isEmpty() ? new Locale(this.language) : Locale.ENGLISH;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("socialWorkspaceId", socialWorkspace.getId());
        props.put("repositoryName", socialWorkspace.getDocument().getRepositoryName());
        props.put("locale", locale);
        props.put("coreSession", (Serializable)this.session);
        props.put("activityLinkBuilderName", this.activityLinkBuilder);
        PageProvider pageProvider = this.pageProviderService.getPageProvider(PROVIDER_NAME, null, targetLimit, Long.valueOf(0L), props, new Object[0]);
        pageProvider.setCurrentPageOffset(targetOffset.longValue());
        ArrayList<Map> activities = new ArrayList<Map>();
        for (ActivityMessage activityMessage : pageProvider.getCurrentPage()) {
            activities.add(activityMessage.toMap(this.session, locale, this.activityLinkBuilder));
        }
        HashMap<String, Serializable> m = new HashMap<String, Serializable>();
        m.put("offset", Long.valueOf(((SocialWorkspaceActivityStreamPageProvider)pageProvider).getNextOffset()));
        m.put("limit", Long.valueOf(pageProvider.getPageSize()));
        m.put("activities", activities);
        ObjectMapper mapper = new ObjectMapper();
        StringWriter writer = new StringWriter();
        mapper.writeValue((Writer)writer, m);
        return new InputStreamBlob((InputStream)new ByteArrayInputStream(writer.toString().getBytes("UTF-8")), "application/json");
    }
}

