/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc.pam;

import java.util.Collection;
import org.jsecurity.authc.AuthenticationException;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.MergableAuthenticationInfo;
import org.jsecurity.authc.SimpleAuthenticationInfo;
import org.jsecurity.authc.pam.ModularAuthenticationStrategy;
import org.jsecurity.realm.Realm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationStrategy
implements ModularAuthenticationStrategy {
    @Override
    public AuthenticationInfo beforeAllAttempts(Collection<? extends Realm> realms, AuthenticationToken token) throws AuthenticationException {
        return new SimpleAuthenticationInfo();
    }

    @Override
    public AuthenticationInfo beforeAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo aggregate) throws AuthenticationException {
        return aggregate;
    }

    @Override
    public AuthenticationInfo afterAttempt(Realm realm, AuthenticationToken token, AuthenticationInfo singleRealmInfo, AuthenticationInfo aggregateInfo, Throwable t) throws AuthenticationException {
        AuthenticationInfo info = singleRealmInfo == null ? aggregateInfo : (aggregateInfo == null ? singleRealmInfo : this.merge(singleRealmInfo, aggregateInfo));
        return info;
    }

    protected AuthenticationInfo merge(AuthenticationInfo info, AuthenticationInfo aggregate) {
        if (aggregate instanceof MergableAuthenticationInfo) {
            ((MergableAuthenticationInfo)aggregate).merge(info);
            return aggregate;
        }
        throw new IllegalArgumentException("Attempt to merge authentication info from multiple realms, but aggreagate AuthenticationInfo is not of type MergableAuthenticationInfo.");
    }

    @Override
    public AuthenticationInfo afterAllAttempts(AuthenticationToken token, AuthenticationInfo aggregate) throws AuthenticationException {
        return aggregate;
    }
}

