/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authz;

import java.util.Collection;
import java.util.List;
import org.jsecurity.authz.AuthorizationException;
import org.jsecurity.authz.Authorizer;
import org.jsecurity.authz.Permission;
import org.jsecurity.authz.UnauthorizedException;
import org.jsecurity.authz.permission.PermissionResolver;
import org.jsecurity.authz.permission.PermissionResolverAware;
import org.jsecurity.realm.Realm;
import org.jsecurity.subject.PrincipalCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModularRealmAuthorizer
implements Authorizer,
PermissionResolverAware {
    protected Collection<Realm> realms;

    public ModularRealmAuthorizer() {
    }

    public ModularRealmAuthorizer(Collection<Realm> realms) {
        this.setRealms(realms);
    }

    public Collection<Realm> getRealms() {
        return this.realms;
    }

    public void setRealms(Collection<Realm> realms) {
        this.realms = realms;
    }

    protected void assertRealmsConfigured() throws IllegalStateException {
        Collection<Realm> realms = this.getRealms();
        if (realms == null || realms.isEmpty()) {
            String msg = "Configuration error:  No realms have been configured!  One or more realms must be present to execute an authorization operation.";
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void setPermissionResolver(PermissionResolver permissionResolver) {
        Collection<Realm> realms = this.getRealms();
        if (realms != null && !realms.isEmpty()) {
            for (Realm realm : realms) {
                if (!(realm instanceof PermissionResolverAware)) continue;
                ((PermissionResolverAware)((Object)realm)).setPermissionResolver(permissionResolver);
            }
        }
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, String permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!realm.isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPermitted(PrincipalCollection principals, Permission permission) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!realm.isPermitted(principals, permission)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, String ... permissions) {
        if (permissions != null && permissions.length > 0) {
            boolean[] isPermitted = new boolean[permissions.length];
            for (int i = 0; i < permissions.length; ++i) {
                isPermitted[i] = this.isPermitted(principals, permissions[i]);
            }
            return isPermitted;
        }
        return new boolean[0];
    }

    @Override
    public boolean[] isPermitted(PrincipalCollection principals, List<Permission> permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            boolean[] isPermitted = new boolean[permissions.size()];
            int i = 0;
            for (Permission p : permissions) {
                isPermitted[i++] = this.isPermitted(principals, p);
            }
            return isPermitted;
        }
        return new boolean[0];
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, String ... permissions) {
        if (permissions != null && permissions.length > 0) {
            for (String perm : permissions) {
                if (this.isPermitted(principals, perm)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPermittedAll(PrincipalCollection principals, Collection<Permission> permissions) {
        if (permissions != null && !permissions.isEmpty()) {
            for (Permission permission : permissions) {
                if (this.isPermitted(principals, permission)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void checkPermission(PrincipalCollection principals, String permission) throws AuthorizationException {
        if (!this.isPermitted(principals, permission)) {
            throw new UnauthorizedException("Subject does not have permission [" + permission + "]");
        }
    }

    @Override
    public void checkPermission(PrincipalCollection principals, Permission permission) throws AuthorizationException {
        if (!this.isPermitted(principals, permission)) {
            throw new UnauthorizedException("Subject does not have permission [" + permission + "]");
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, String ... permissions) throws AuthorizationException {
        if (permissions != null && permissions.length > 0) {
            for (String perm : permissions) {
                this.checkPermission(principals, perm);
            }
        }
    }

    @Override
    public void checkPermissions(PrincipalCollection principals, Collection<Permission> permissions) throws AuthorizationException {
        if (permissions != null) {
            for (Permission permission : permissions) {
                this.checkPermission(principals, permission);
            }
        }
    }

    @Override
    public boolean hasRole(PrincipalCollection principals, String roleIdentifier) {
        this.assertRealmsConfigured();
        for (Realm realm : this.getRealms()) {
            if (!realm.hasRole(principals, roleIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean[] hasRoles(PrincipalCollection principals, List<String> roleIdentifiers) {
        if (roleIdentifiers != null && !roleIdentifiers.isEmpty()) {
            boolean[] hasRoles = new boolean[roleIdentifiers.size()];
            int i = 0;
            for (String roleId : roleIdentifiers) {
                hasRoles[i++] = this.hasRole(principals, roleId);
            }
            return hasRoles;
        }
        return new boolean[0];
    }

    @Override
    public boolean hasAllRoles(PrincipalCollection principals, Collection<String> roleIdentifiers) {
        for (String roleIdentifier : roleIdentifiers) {
            if (this.hasRole(principals, roleIdentifier)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void checkRole(PrincipalCollection principals, String role) throws AuthorizationException {
        if (!this.hasRole(principals, role)) {
            throw new UnauthorizedException("Subject does not have role [" + role + "]");
        }
    }

    @Override
    public void checkRoles(PrincipalCollection principals, Collection<String> roles) throws AuthorizationException {
        if (roles != null) {
            for (String role : roles) {
                this.checkRole(principals, role);
            }
        }
    }
}

