/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.session.mgt;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.session.ExpiredSessionException;
import org.jsecurity.session.InvalidSessionException;
import org.jsecurity.session.StoppedSessionException;
import org.jsecurity.session.mgt.ValidatingSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSession
implements ValidatingSession,
Serializable {
    protected static final long MILLIS_PER_SECOND = 1000L;
    protected static final long MILLIS_PER_MINUTE = 60000L;
    protected static final long MILLIS_PER_HOUR = 3600000L;
    private static final transient Log log = LogFactory.getLog(SimpleSession.class);
    private Serializable id = null;
    private Date startTimestamp = null;
    private Date stopTimestamp = null;
    private Date lastAccessTime = this.startTimestamp = new Date();
    private long timeout = 1800000L;
    private boolean expired = false;
    private InetAddress hostAddress = null;
    private Map<Object, Object> attributes = null;

    public SimpleSession() {
        this(SimpleSession.getLocalHost());
    }

    public SimpleSession(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    private static InetAddress getLocalHost() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public Serializable getId() {
        return this.id;
    }

    public void setId(Serializable id) {
        this.id = id;
    }

    @Override
    public Date getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(Date startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Date getStopTimestamp() {
        return this.stopTimestamp;
    }

    public void setStopTimestamp(Date stopTimestamp) {
        this.stopTimestamp = stopTimestamp;
    }

    @Override
    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
    }

    public Map<Object, Object> getAttributes() {
        this.touch();
        return this.attributes;
    }

    public void setAttributes(Map<Object, Object> attributes) {
        this.touch();
        this.attributes = attributes;
    }

    @Override
    public void touch() {
        this.lastAccessTime = new Date();
    }

    @Override
    public void stop() {
        if (this.stopTimestamp == null) {
            this.stopTimestamp = new Date();
        }
    }

    protected boolean isStopped() {
        return this.getStopTimestamp() != null;
    }

    protected void expire() {
        this.stop();
        if (!this.expired) {
            this.expired = true;
        }
    }

    @Override
    public boolean isValid() {
        return !this.isStopped() && !this.isExpired();
    }

    protected boolean isTimedOut() {
        if (this.isExpired()) {
            return true;
        }
        long timeout = this.getTimeout();
        if (timeout >= 0L) {
            Date lastAccessTime = this.getLastAccessTime();
            if (lastAccessTime == null) {
                String msg = "session.lastAccessTime for session with id [" + this.getId() + "] is null.  This value must be set at " + "least once, preferably at least upon instantiation.  Please check the " + this.getClass().getName() + " implementation and ensure " + "this value will be set (perhaps in the constructor?)";
                throw new IllegalStateException(msg);
            }
            long expireTimeMillis = System.currentTimeMillis() - timeout;
            Date expireTime = new Date(expireTimeMillis);
            return lastAccessTime.before(expireTime);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("No timeout for session with id [" + this.getId() + "].  Session is not considered expired."));
        }
        return false;
    }

    @Override
    public void validate() throws InvalidSessionException {
        if (this.isStopped()) {
            String msg = "Session with id [" + this.getId() + "] has been " + "explicitly stopped.  No further interaction under this session is " + "allowed.";
            throw new StoppedSessionException(msg, this.getId());
        }
        if (this.isTimedOut()) {
            this.expire();
            Date lastAccessTime = this.getLastAccessTime();
            long timeout = this.getTimeout();
            Serializable sessionId = this.getId();
            DateFormat df = DateFormat.getInstance();
            String msg = "Session with id [" + sessionId + "] has expired. " + "Last access time: " + df.format(lastAccessTime) + ".  Current time: " + df.format(new Date()) + ".  Session timeout is set to " + timeout / 1000L + " seconds (" + timeout / 60000L + " minutes)";
            if (log.isTraceEnabled()) {
                log.trace((Object)msg);
            }
            throw new ExpiredSessionException(msg, sessionId);
        }
    }

    private Map<Object, Object> getAttributesLazy() {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            attributes = new HashMap<Object, Object>();
            this.setAttributes(attributes);
        }
        return attributes;
    }

    @Override
    public Collection<Object> getAttributeKeys() throws InvalidSessionException {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return Collections.EMPTY_SET;
        }
        return attributes.keySet();
    }

    @Override
    public Object getAttribute(Object key) {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    @Override
    public void setAttribute(Object key, Object value) {
        if (value == null) {
            this.removeAttribute(key);
        } else {
            this.getAttributesLazy().put(key, value);
        }
    }

    @Override
    public Object removeAttribute(Object key) {
        Map<Object, Object> attributes = this.getAttributes();
        if (attributes == null) {
            return null;
        }
        return attributes.remove(key);
    }
}

