/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.cache.NullCache;
import org.apache.shindig.gadgets.DefaultGadgetSpecFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.BasicHttpFetcher;
import org.apache.shindig.gadgets.http.DefaultHttpCache;
import org.apache.shindig.gadgets.http.DefaultRequestPipeline;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.gadgets.http.NoOpInvalidationService;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.opensocial.gadgets.service.ExternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.InternalGadgetDescriptor;
import org.nuxeo.opensocial.gadgets.service.NXGadgetContext;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class GadgetServiceImpl
extends DefaultComponent
implements GadgetService {
    private static final String GADGET_XP = "gadget";
    private static final HashMap<String, GadgetDeclaration> internalGadgets = new HashMap();
    public static final String GADGET_DIRECTORY = "externalGadgets";
    private static final Log log = LogFactory.getLog(GadgetServiceImpl.class);
    private static final String GADGET_DIR_SCHEMA = "externalgadget";
    private static final String EXTERNAL_PROP_NAME = "label";
    private static final String EXTERNAL_PROP_CATEGORY = "category";
    private static final String EXTERNAL_PROP_ENABLED = "enabled";
    private static final String EXTERNAL_PROP_URL = "url";
    private static final String EXTERNAL_PROP_ICON_URL = "iconUrl";

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (GADGET_XP.equals(extensionPoint)) {
            InternalGadgetDescriptor gadget = (InternalGadgetDescriptor)contribution;
            gadget.setComponentName(contributor.getName());
            this.registerNewGadget(gadget);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (GADGET_XP.equals(extensionPoint)) {
            InternalGadgetDescriptor gadget = (InternalGadgetDescriptor)contribution;
            this.unregisterNewGadget(gadget, contributor);
        }
    }

    public void registerNewGadget(GadgetDeclaration gadget) {
        if (internalGadgets.containsKey(gadget.getName())) {
            internalGadgets.remove(gadget.getName());
        }
        if (!gadget.getDisabled()) {
            internalGadgets.put(gadget.getName(), gadget);
        }
    }

    private void unregisterNewGadget(GadgetDeclaration gadget, ComponentInstance contributor) {
        if (internalGadgets.containsKey(gadget.getName())) {
            internalGadgets.remove(gadget.getName());
        }
    }

    @Override
    public GadgetDeclaration getGadget(String name) {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        if (gadgets.containsKey(name)) {
            return gadgets.get(name);
        }
        return null;
    }

    @Override
    public InputStream getGadgetResource(String gadgetName, String resourcePath) throws IOException {
        return this.getGadget(gadgetName).getResourceAsStream(resourcePath);
    }

    @Override
    public GadgetSpec getGadgetSpec(String name) throws IOException, GadgetException {
        GadgetDeclaration dec = this.getGadget(name);
        return this.getGadgetSpec(dec);
    }

    @Override
    public GadgetSpec getGadgetSpec(GadgetDeclaration declaration) throws IOException, GadgetException {
        if (declaration == null) {
            return null;
        }
        GadgetSpecFactory gadgetSpecFactory = null;
        if (Framework.isTestModeSet()) {
            DefaultHttpCache dummyCache = new DefaultHttpCache((CacheProvider)new LruCacheProvider(0));
            DefaultRequestPipeline pipe = new DefaultRequestPipeline((HttpFetcher)new BasicHttpFetcher(), (HttpCache)dummyCache, null, null, (InvalidationService)new NoOpInvalidationService());
            CacheProvider cacheProvider = new CacheProvider(){

                public <K, V> Cache<K, V> createCache(String name) {
                    return new NullCache();
                }
            };
            gadgetSpecFactory = new DefaultGadgetSpecFactory(null, (RequestPipeline)pipe, cacheProvider, 0L);
        } else {
            OpenSocialService service = (OpenSocialService)Framework.getService(OpenSocialService.class);
            gadgetSpecFactory = service.getGadgetSpecFactory();
        }
        NXGadgetContext context = null;
        if (declaration instanceof InternalGadgetDescriptor) {
            String xmlDef;
            InternalGadgetDescriptor internal = (InternalGadgetDescriptor)declaration;
            InputStream is = internal.getResourceAsStream(internal.entryPoint);
            if (is == null) {
                String resourcePath = internal.getMountPoint() + "/" + internal.getEntryPoint();
                resourcePath = resourcePath.replaceFirst("/", "");
                is = GadgetServiceImpl.class.getClassLoader().getResourceAsStream(resourcePath);
            }
            context = (xmlDef = FileUtils.read((InputStream)is)).contains("<#") ? new NXGadgetContext(declaration.getGadgetDefinition()) : new NXGadgetContext(declaration.getGadgetDefinition(), xmlDef);
        } else {
            context = new NXGadgetContext(declaration.getGadgetDefinition());
        }
        GadgetSpec gadgetSpec = gadgetSpecFactory.getGadgetSpec((GadgetContext)context);
        return gadgetSpec;
    }

    @Override
    public List<GadgetDeclaration> getGadgetList() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        ArrayList<GadgetDeclaration> gadgetList = new ArrayList<GadgetDeclaration>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            gadgetList.add(gadget);
        }
        return gadgetList;
    }

    @Override
    public List<GadgetDeclaration> getGadgetList(String category) {
        List<GadgetDeclaration> all = this.getGadgetList();
        if (category == null) {
            return all;
        }
        ArrayList<GadgetDeclaration> result = new ArrayList<GadgetDeclaration>();
        for (GadgetDeclaration gd : all) {
            if (!category.equals(gd.getCategory())) continue;
            result.add(gd);
        }
        return result;
    }

    public HashMap<String, ArrayList<String>> getGadgetNameByCategory() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        HashMap<String, ArrayList<String>> listByCategories = new HashMap<String, ArrayList<String>>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            ArrayList<String> listGadget;
            if (listByCategories.containsKey(gadget.getCategory())) {
                listGadget = listByCategories.get(gadget.getCategory());
                listGadget.add(gadget.getName());
                continue;
            }
            if (gadget.getCategory() == null) continue;
            listGadget = new ArrayList();
            listGadget.add(gadget.getName());
            listByCategories.put(gadget.getCategory(), listGadget);
        }
        return listByCategories;
    }

    @Override
    public URL getGadgetDefinition(String gadgetName) {
        GadgetDeclaration gadget = this.getGadget(gadgetName);
        if (gadget == null) {
            log.warn((Object)("Unable to find gadget" + gadgetName));
            return null;
        }
        return gadget.getGadgetDefinition();
    }

    @Override
    public List<String> getGadgetCategory() {
        Map<String, GadgetDeclaration> gadgets = this.getInternalAndExternalGadgets();
        ArrayList<String> categories = new ArrayList<String>();
        for (GadgetDeclaration gadget : gadgets.values()) {
            if (gadget.getCategory() == null || categories.contains(gadget.getCategory())) continue;
            categories.add(gadget.getCategory());
        }
        return categories;
    }

    @Override
    public String getIconUrl(String gadgetName) {
        return this.getGadget(gadgetName).getIconUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, GadgetDeclaration> getInternalAndExternalGadgets() {
        HashMap<String, GadgetDeclaration> result = new HashMap<String, GadgetDeclaration>();
        for (String key : internalGadgets.keySet()) {
            result.put(key, internalGadgets.get(key));
        }
        try (Session session = null;){
            DirectoryService dirService = (DirectoryService)Framework.getService(DirectoryService.class);
            session = dirService.open(GADGET_DIRECTORY);
            for (DocumentModel model : session.getEntries()) {
                String iconURL;
                String gadgetDefinition;
                long enabled;
                boolean disabled;
                String name = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_NAME);
                String category = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_CATEGORY);
                ExternalGadgetDescriptor desc = new ExternalGadgetDescriptor(category, disabled = (enabled = ((Long)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_ENABLED)).longValue()) == 0L, new URL(gadgetDefinition = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_URL)), iconURL = (String)model.getProperty(GADGET_DIR_SCHEMA, EXTERNAL_PROP_ICON_URL), name);
                if (desc.getDisabled()) continue;
                result.put(desc.getName(), desc);
            }
        }
        catch (Exception e) {
            log.error((Object)"Unable to read external gadget directory!", (Throwable)e);
        }
        return result;
    }
}

