/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.agenda.seam;

import java.io.Serializable;
import java.security.Principal;
import java.util.Map;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.automation.InvalidChainException;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.relations.api.DocumentRelationManager;
import org.nuxeo.ecm.platform.relations.api.exceptions.RelationAlreadyExistsException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Name(value="agendaAddToEventAction")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class AddToEventAction
implements Serializable {
    private static final long serialVersionUID = 3930167063686290160L;
    private static final String PREDICATE_TYPE = "http://purl.org/dc/terms/References";
    private String selectedAgendaId = null;
    @In(create=true)
    protected Map<String, String> messages;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected DocumentRelationManager documentRelationManager;
    @In(create=true)
    protected NavigationContext navigationContext;
    @In(required=false)
    protected transient Principal currentUser;
    private String selectedEventId = null;

    public String getSelectedAgendaId() {
        return this.selectedAgendaId;
    }

    public void setSelectedAgendaId(String selectedAgendaId) {
        this.selectedAgendaId = selectedAgendaId;
        this.selectedEventId = null;
    }

    public String getSelectedEventId() {
        return this.selectedEventId;
    }

    public void setSelectedEventId(String selectedEventId) {
        this.selectedEventId = selectedEventId;
    }

    public void addToEvent() throws InvalidChainException, OperationException, Exception {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(this.selectedEventId));
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        try {
            this.documentRelationManager.addRelation(this.documentManager, currentDoc, doc, PREDICATE_TYPE, true);
            this.facesMessages.add(StatusMessage.Severity.INFO, this.messages.get("label.relation.created"), new Object[0]);
        }
        catch (RelationAlreadyExistsException e) {
            this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("label.relation.already.exists"), new Object[0]);
        }
    }

    public void cancelAddToEvent() {
        this.selectedEventId = null;
        this.selectedAgendaId = null;
    }
}

