/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.speechtotext.google;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.labs.speechtotext.api.SpeechToTextResponse;

public class GoogleRESTSpeechToTextResponse
implements SpeechToTextResponse {
    protected JSONObject jsonResponse = null;
    protected String cachedText = null;
    protected Double cachedConfidence = null;

    public GoogleRESTSpeechToTextResponse(String httpResponse) throws JSONException {
        try {
            this.jsonResponse = new JSONObject(httpResponse);
        }
        catch (JSONException e) {
            this.buildErrorResponse((Exception)((Object)e));
        }
    }

    protected void buildErrorResponse(Exception exception) throws JSONException {
        this.jsonResponse = new JSONObject();
        JSONArray results = new JSONArray();
        JSONObject firstResult = new JSONObject();
        JSONArray alternatives = new JSONArray();
        JSONObject errorAlternative = new JSONObject();
        errorAlternative.put("transcript", (Object)("AN ERROR OCCURED: " + exception.getMessage()));
        errorAlternative.put("confidence", 0);
        JSONArray words = new JSONArray();
        errorAlternative.put("words", (Object)words);
        alternatives.put((Object)errorAlternative);
        firstResult.put("alternatives", (Object)alternatives);
        results.put((Object)firstResult);
        this.jsonResponse.put("results", (Object)results);
    }

    protected JSONObject getFirstAlternative() throws JSONException {
        JSONObject alternative = null;
        JSONArray results = this.jsonResponse.getJSONArray("results");
        JSONObject firstResult = results.getJSONObject(0);
        JSONArray alternatives = firstResult.getJSONArray("alternatives");
        alternative = alternatives.getJSONObject(0);
        return alternative;
    }

    protected double parseDuration(String secondsStr) {
        double result = 0.0;
        if (StringUtils.isNotBlank((CharSequence)secondsStr)) {
            int pos = secondsStr.indexOf("s");
            if (pos > -1) {
                secondsStr = secondsStr.substring(0, pos);
            }
            if ((pos = secondsStr.indexOf(".")) > -1 && secondsStr.length() > pos + 4) {
                secondsStr = secondsStr.substring(0, pos + 4);
            }
            result = Double.parseDouble(secondsStr);
        }
        return result;
    }

    @Override
    public String getText() {
        if (this.cachedText == null) {
            try {
                JSONObject alternative = this.getFirstAlternative();
                this.cachedText = alternative.getString("transcript");
            }
            catch (JSONException e) {
                throw new NuxeoException("Cannot get the first alternative to read its transcript", (Throwable)e);
            }
        }
        return this.cachedText;
    }

    @Override
    public double getConfidence() {
        if (this.cachedConfidence == null) {
            try {
                JSONObject alternative = this.getFirstAlternative();
                this.cachedConfidence = alternative.getDouble("confidence");
            }
            catch (JSONException e) {
                throw new NuxeoException("Cannot get the first alternative to read its confidence", (Throwable)e);
            }
        }
        if (this.cachedConfidence == null) {
            return -1.0;
        }
        return this.cachedConfidence;
    }

    @Override
    public JSONArray getWordTimeOffsets(boolean withSpeakerTag) throws JSONException {
        JSONArray array = new JSONArray();
        JSONObject alternative = this.getFirstAlternative();
        JSONArray resultWords = alternative.getJSONArray("words");
        if (resultWords != null) {
            int max = resultWords.length();
            for (int i = 0; i < max; ++i) {
                JSONObject oneResultWord = resultWords.getJSONObject(i);
                JSONObject obj = new JSONObject();
                obj.put("word", (Object)oneResultWord.getString("word"));
                obj.put("start", this.parseDuration(oneResultWord.getString("startTime")));
                obj.put("end", this.parseDuration(oneResultWord.getString("endTime")));
                if (withSpeakerTag) {
                    obj.put("speakerTag", oneResultWord.getInt("speakerTag"));
                }
                array.put((Object)obj);
            }
        }
        return array;
    }

    @Override
    public Object getNativeResponse() {
        return this.jsonResponse;
    }
}

