/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.speechtotext.operations;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.labs.speechtotext.api.SpeechToText;
import org.nuxeo.labs.speechtotext.api.SpeechToTextOptions;
import org.nuxeo.labs.speechtotext.api.SpeechToTextResponse;

@Operation(id="Convert.SpeechToTextForBlob", category="Conversion", label="Blob: Speech to Text", description="Send the input blob to the SpeechToText service, using the languageCode. If the blob is a FLAC or a WAV audio file, audioEncoding and sampleRateHertz are optional and can be ommited. If passed, audioEncoding must be a valid value, case sensitive (LINEAR16, FLAC, MULAW ... Misc. options can be set (punctuation, wordTimeOffsets.) The resultVarName context variable is set to the SpeechToTextResponse object with the transcript, word time offsets ... The operation returns the input blob unchanged")
public class SpeechToTextForBlob {
    public static final String ID = "Convert.SpeechToTextForBlob";
    @Context
    protected CoreSession session;
    @Context
    protected OperationContext ctx;
    @Context
    protected SpeechToText speechToText;
    @Param(name="languageCode", required=true, values={"en-US"})
    protected String languageCode = "en-US";
    @Param(name="audioEncoding", required=false)
    protected String audioEncoding;
    @Param(name="sampleRateHertz", required=false)
    protected int sampleRateHertz;
    @Param(name="withPunctuation", required=false, values={"true"})
    protected boolean withPunctuation = true;
    @Param(name="withWordTimeOffets", required=false, values={"false"})
    protected boolean withWordTimeOffets = false;
    @Param(name="moreOptionsJSONStr", required=false)
    protected String moreOptionsJSONStr = null;
    @Param(name="resultVarName", required=true)
    protected String resultVarName;

    @OperationMethod
    public Blob run(Blob input) throws JSONException {
        SpeechToTextOptions options = new SpeechToTextOptions(this.withPunctuation, this.withWordTimeOffets);
        JSONObject moreOptions = null;
        if (StringUtils.isNotBlank((CharSequence)this.moreOptionsJSONStr)) {
            moreOptions = new JSONObject(this.moreOptionsJSONStr);
        }
        SpeechToTextResponse response = this.speechToText.run(options, input, this.audioEncoding, this.sampleRateHertz, this.languageCode, moreOptions);
        this.ctx.put(this.resultVarName, (Object)response);
        return input;
    }
}

