/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.speechtotext.google;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.labs.speechtotext.api.SpeechToText;
import org.nuxeo.labs.speechtotext.api.SpeechToTextOptions;
import org.nuxeo.labs.speechtotext.api.SpeechToTextProvider;
import org.nuxeo.labs.speechtotext.api.SpeechToTextResponse;
import org.nuxeo.labs.speechtotext.google.GoogleRESTSpeechToTextResponse;
import org.nuxeo.runtime.api.Framework;

public class GoogleSpeechToTextProvider
implements SpeechToTextProvider {
    public static final String SPEECHTOTEXT_API_VERSION = "v1p1beta1";
    public static final String API_KEY_PARAM = "google.speechtotext.apikey";
    public static final String API_KEY_ENV_VAR = "GOOGLE_SPEECHTOTEXT_APIKEY";

    @Override
    public SpeechToTextResponse run(SpeechToTextOptions options, Blob blob, String languageCode, JSONObject moreOptions) {
        Blob normalized = this.normalizeAudio(blob);
        return this.run(options, normalized, null, -1, languageCode, moreOptions);
    }

    @Override
    public SpeechToTextResponse run(SpeechToTextOptions options, Blob blob, String audioEncoding, int sampleRateHertz, String languageCode, JSONObject moreOptions) {
        return this.runWithREST(options, blob, audioEncoding, sampleRateHertz, languageCode, moreOptions);
    }

    protected String getGoogleSpeechToTextAPIKey() {
        String apiKey = Framework.getProperty((String)API_KEY_PARAM);
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            apiKey = System.getenv(API_KEY_ENV_VAR);
        }
        if (StringUtils.isBlank((CharSequence)apiKey)) {
            throw new NuxeoException("API Keyfor Google Speech To Text APi not found in nuxeo.conf (google.speechtotext.apikey) nor in an environement variable (GOOGLE_SPEECHTOTEXT_APIKEY)");
        }
        return apiKey;
    }

    protected boolean isFlacOrWav(Blob blob) {
        String mimeTypeLowerCase;
        String mimeType = blob.getMimeType();
        return StringUtils.isNotBlank((CharSequence)mimeType) && ((mimeTypeLowerCase = mimeType.toLowerCase()).indexOf("flac") > -1 || mimeTypeLowerCase.indexOf("wav") > -1);
    }

    protected Blob normalizeAudio(Blob blob) {
        if (this.isFlacOrWav(blob)) {
            return blob;
        }
        ConversionService service = (ConversionService)Framework.getService(ConversionService.class);
        SimpleBlobHolder blobholder = new SimpleBlobHolder(blob);
        BlobHolder result = service.convert("audio-to-flac", (BlobHolder)blobholder, new HashMap());
        return result.getBlob();
    }

    protected SpeechToTextResponse runWithREST(SpeechToTextOptions options, Blob blob, String audioEncoding, int sampleRateHertz, String languageCode, JSONObject moreOptions) {
        GoogleRESTSpeechToTextResponse response = null;
        if (options == null) {
            options = SpeechToTextOptions.buildDefaultOptions();
        }
        CloseableHttpClient client = HttpClients.createDefault();
        try {
            byte[] data = blob.getByteArray();
            String audioStr = Base64.getEncoder().encodeToString(data);
            JSONObject jsonBody = new JSONObject();
            JSONObject audioJson = new JSONObject();
            audioJson.put("content", (Object)audioStr);
            jsonBody.put("audio", (Object)audioJson);
            JSONObject config = new JSONObject();
            config.put("languageCode", (Object)languageCode);
            config.put("enableAutomaticPunctuation", options.isWithPunctuation());
            config.put("enableWordTimeOffsets", options.isWithWordTimeOffsets());
            if (!this.isFlacOrWav(blob)) {
                config.put("encoding", (Object)audioEncoding);
                config.put("sampleRateHertz", sampleRateHertz);
            }
            if (options.isWithDetectSpeakers()) {
                config.put("enableSpeakerDiarization", true);
                config.put("diarizationSpeakerCount", 2);
            }
            config = SpeechToText.mergeJSONObjects(config, moreOptions);
            jsonBody.put("config", (Object)config);
            String bodyJsonStr = jsonBody.toString();
            String url = "https://speech.googleapis.com/v1p1beta1/speech:recognize?key=" + this.getGoogleSpeechToTextAPIKey();
            HttpPost httpPost = new HttpPost(url);
            StringEntity bodyEntity = new StringEntity(bodyJsonStr);
            httpPost.setEntity((HttpEntity)bodyEntity);
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("Content-type", "application/json");
            CloseableHttpResponse httpResponse = client.execute((HttpUriRequest)httpPost);
            int httpResponsecode = httpResponse.getStatusLine().getStatusCode();
            if (httpResponsecode != 200) {
                throw new NuxeoException("Problem calling the service, Status code: " + httpResponsecode + ", " + httpResponse.getStatusLine().getReasonPhrase());
            }
            HttpEntity responseEntity = httpResponse.getEntity();
            BufferedHttpEntity buf = new BufferedHttpEntity(responseEntity);
            String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
            response = new GoogleRESTSpeechToTextResponse(responseContent);
        }
        catch (IOException | JSONException e) {
            throw new NuxeoException("Error getting the speech-to-text result.", e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
        return response;
    }
}

