/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.spreadsheet;

import com.google.common.base.Joiner;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.contentview.jsf.ContentView;
import org.nuxeo.ecm.platform.contentview.jsf.ContentViewService;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryAndFetchPageProvider;
import org.nuxeo.ecm.platform.query.nxql.CoreQueryDocumentPageProvider;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

@Name(value="spreadsheetActions")
@Scope(value=ScopeType.EVENT)
public class SpreadsheetActions
implements Serializable {
    @In(create=true)
    protected ContentViewService contentViewService;

    public String urlFor(ContentView contentView) throws UnsupportedEncodingException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("layout", contentView.getCurrentResultLayout().getName());
        List columns = contentView.getCurrentResultLayoutColumns();
        if (columns != null) {
            params.put("columns", Joiner.on((char)',').join((Iterable)columns));
        }
        params.put("provider", contentView.getPageProvider().getName());
        String query = this.getQuery(contentView);
        if (query != null) {
            query = URLEncoder.encode(query, "UTF-8");
            query = query.replaceAll("\\+", "%20");
        }
        params.put("query", query);
        return VirtualHostHelper.getContextPathProperty() + "/spreadsheet?" + Joiner.on((char)'&').withKeyValueSeparator("=").join(params);
    }

    protected String getQuery(ContentView contentView) {
        String query;
        PageProviderDefinition def;
        PageProvider pp = contentView.getPageProvider();
        if (!(pp instanceof CoreQueryAndFetchPageProvider) && !(pp instanceof CoreQueryDocumentPageProvider)) {
            return "";
        }
        SortInfo[] sortArray = null;
        List sortInfos = pp.getSortInfos();
        if (sortInfos != null) {
            sortArray = sortInfos.toArray(new SortInfo[0]);
        }
        if ((def = pp.getDefinition()).getWhereClause() == null) {
            query = NXQLQueryBuilder.getQuery((String)def.getPattern(), (Object[])pp.getParameters(), (boolean)def.getQuotePatternParameters(), (boolean)def.getEscapePatternParameters(), (DocumentModel)pp.getSearchDocumentModel(), (SortInfo[])sortArray);
        } else {
            DocumentModel searchDocumentModel = pp.getSearchDocumentModel();
            if (searchDocumentModel == null) {
                throw new ClientException(String.format("Cannot build query of provider '%s': no search document model is set", pp.getName()));
            }
            query = NXQLQueryBuilder.getQuery((DocumentModel)searchDocumentModel, (WhereClauseDefinition)def.getWhereClause(), (Object[])pp.getParameters(), (SortInfo[])sortArray);
        }
        return query;
    }
}

