/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.spreadsheet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class DCVocabulariesJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    private static final Log log = LogFactory.getLog(DCVocabulariesJsonEnricher.class);
    public static final String NAME = "vocabularies";
    private static final String DIRECTORY_DEFAULT_LABEL_PREFIX = "label_";
    private static final String KEY_SEPARATOR = "/";
    @Inject
    private DirectoryService directoryService;
    @Inject
    private SchemaManager schemaManager;

    public DCVocabulariesJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        this.writeVocabulary(jg, document, "l10nsubjects", "dc:subjects");
        this.writeVocabulary(jg, document, "l10ncoverage", "dc:coverage");
    }

    private void writeVocabulary(JsonGenerator jg, DocumentModel doc, String directoryName, String fieldName) throws IOException, JsonGenerationException {
        try {
            List<String> labelFields = this.getLabelFields(directoryName);
            String[] entriesIds = DCVocabulariesJsonEnricher.getPropertyValues(doc, fieldName);
            jg.writeFieldName(fieldName);
            jg.writeStartArray();
            if (entriesIds != null) {
                this.writeLabels(jg, directoryName, entriesIds, labelFields);
            }
            jg.writeEndArray();
        }
        catch (PropertyNotFoundException | DirectoryException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLabels(JsonGenerator jg, String directoryName, String[] entriesIds, List<String> labelFields) throws IOException {
        try (Session session = null;){
            session = this.directoryService.open(directoryName);
            for (String entryId : entriesIds) {
                Map<String, String> labels = DCVocabulariesJsonEnricher.getAbsoluteLabels(entryId, session, labelFields);
                jg.writeStartObject();
                jg.writeStringField("id", entryId);
                for (Map.Entry<String, String> label : labels.entrySet()) {
                    jg.writeStringField(label.getKey(), label.getValue());
                }
                jg.writeEndObject();
            }
        }
    }

    private List<String> getLabelFields(String directoryName) {
        String schemaName = this.directoryService.getDirectorySchema(directoryName);
        Schema schema = this.schemaManager.getSchema(schemaName);
        ArrayList<String> labelFields = new ArrayList<String>();
        for (Field field : schema.getFields()) {
            String fieldName = field.getName().toString();
            if (!fieldName.startsWith(DIRECTORY_DEFAULT_LABEL_PREFIX)) continue;
            labelFields.add(fieldName);
        }
        return labelFields;
    }

    private static String[] getPropertyValues(DocumentModel doc, String fieldName) {
        String[] entriesIds = null;
        Property prop = doc.getProperty(fieldName);
        if (prop.isList()) {
            entriesIds = (String[])prop.getValue(String[].class);
        } else {
            String value = (String)prop.getValue(String.class);
            if (value != null) {
                entriesIds = new String[]{value};
            }
        }
        return entriesIds;
    }

    private static Map<String, String> getAbsoluteLabels(String entryId, Session session, List<String> labelFields) throws ClientException {
        String[] split = entryId.split(KEY_SEPARATOR);
        HashMap<String, String> labels = new HashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            DocumentModel entry = session.getEntry(split[i]);
            if (entry == null) continue;
            for (String labelField : labelFields) {
                String result = (String)labels.get(labelField);
                if (result == null) {
                    result = "";
                }
                String value = (String)((Object)entry.getPropertyValue(labelField));
                result = result + (i > 0 ? KEY_SEPARATOR : "") + value;
                labels.put(labelField, result);
            }
        }
        return labels;
    }
}

