/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.targetplatforms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.targetplatforms.api.TargetPlatformFilter;
import org.nuxeo.targetplatforms.api.impl.TargetPlatformFilterImpl;
import org.nuxeo.targetplatforms.api.service.TargetPlatformService;
import org.nuxeo.targetplatforms.io.JSONExporter;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;

public class TargetPlatformsRestlet
extends BaseNuxeoRestlet {
    private static final String PUBLIC_TP_CACHE_KEY = "PUBLIC_TP";
    private static final LoadingCache<String, String> PUBLIC_CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).refreshAfterWrite(10L, TimeUnit.MINUTES).recordStats().maximumSize(5L).build((CacheLoader)new CacheLoader<String, String>(){

        public String load(String key) throws Exception {
            return key;
        }
    });

    public void handle(Request request, Response response) {
        HttpServletResponse res = TargetPlatformsRestlet.getHttpResponse((Response)response);
        if (res == null || res.isCommitted()) {
            return;
        }
        try {
            String targetPlatforms = this.getTargetPlatforms();
            response.setEntity(targetPlatforms, MediaType.APPLICATION_JSON);
        }
        catch (ExecutionException e) {
            response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
        }
    }

    private String getTargetPlatforms() throws ExecutionException {
        return (String)PUBLIC_CACHE.get((Object)PUBLIC_TP_CACHE_KEY, (Callable)new TargetPlatformCallable());
    }

    private static class TargetPlatformCallable
    implements Callable<String> {
        private TargetPlatformCallable() {
        }

        @Override
        public String call() throws Exception {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TargetPlatformService tps = (TargetPlatformService)Framework.getService(TargetPlatformService.class);
                ArrayList res = tps.getAvailableTargetPlatforms((TargetPlatformFilter)new TargetPlatformFilterImpl(false, true, true, false, null));
                if (res == null) {
                    res = new ArrayList();
                }
                JSONExporter.exportToJson(res, (OutputStream)baos, (boolean)false);
                String string = new String(baos.toByteArray());
                return string;
            }
        }
    }
}

