/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.nuxeo.targetplatforms.api.TargetPackage;
import org.nuxeo.targetplatforms.api.TargetPackageInfo;
import org.nuxeo.targetplatforms.api.TargetPlatform;
import org.nuxeo.targetplatforms.api.TargetPlatformInfo;
import org.nuxeo.targetplatforms.api.TargetPlatformInstance;
import org.nuxeo.targetplatforms.io.JSONExporter;
import org.nuxeo.targetplatforms.jaxrs.TargetPlatforms;
import org.nuxeo.targetplatforms.jaxrs.TargetPlatformsInfo;

@Provider
@Produces(value={"application/json", "text/plain"})
public class JsonWriter
implements MessageBodyWriter<Object> {
    @Context
    protected HttpServletRequest request;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return TargetPackageInfo.class.isAssignableFrom(type) || TargetPackage.class.isAssignableFrom(type) || TargetPlatformInfo.class.isAssignableFrom(type) || TargetPlatformInstance.class.isAssignableFrom(type) || TargetPlatform.class.isAssignableFrom(type) || TargetPlatformsInfo.class.isAssignableFrom(type) || TargetPlatforms.class.isAssignableFrom(type);
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        boolean pretty = Boolean.parseBoolean(this.request.getParameter("pretty"));
        if (TargetPackage.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((TargetPackage)((TargetPackage)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPackageInfo.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((TargetPackageInfo)((TargetPackageInfo)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPlatform.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((TargetPlatform)((TargetPlatform)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPlatformInstance.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((TargetPlatformInstance)((TargetPlatformInstance)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPlatformInfo.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((TargetPlatformInfo)((TargetPlatformInfo)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPlatforms.class.isAssignableFrom(type)) {
            JSONExporter.exportToJson((List)((TargetPlatforms)t), (OutputStream)entityStream, (boolean)pretty);
        } else if (TargetPlatformsInfo.class.isAssignableFrom(type)) {
            JSONExporter.exportInfosToJson((List)((TargetPlatformsInfo)t), (OutputStream)entityStream, (boolean)pretty);
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type '%s'", type));
        }
    }
}

