/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.core.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.targetplatforms.core.descriptors.TargetDescriptor;

@XObject(value="platform")
public class TargetPlatformDescriptor
extends TargetDescriptor {
    @XNode(value="fastTrack")
    Boolean fastTrack;
    @XNode(value="trial")
    Boolean trial;
    @XNode(value="default")
    Boolean isDefault;
    @XNodeList(value="testVersions/version", type=ArrayList.class, componentType=String.class)
    List<String> testVersions;

    public boolean isFastTrackSet() {
        return this.fastTrack != null;
    }

    public boolean isFastTrack() {
        return Boolean.TRUE.equals(this.fastTrack);
    }

    public boolean isTrialSet() {
        return this.trial != null;
    }

    public boolean isTrial() {
        return Boolean.TRUE.equals(this.trial);
    }

    public boolean isDefaultSet() {
        return this.isDefault != null;
    }

    public boolean isDefault() {
        return Boolean.TRUE.equals(this.isDefault);
    }

    public List<String> getTestVersions() {
        return this.testVersions;
    }

    @Override
    public TargetPlatformDescriptor clone() {
        TargetPlatformDescriptor clone = new TargetPlatformDescriptor();
        this.doClone(clone);
        return clone;
    }

    protected void doClone(TargetPlatformDescriptor clone) {
        super.doClone(clone);
        clone.fastTrack = this.fastTrack;
        clone.trial = this.trial;
        clone.isDefault = this.isDefault;
        if (this.testVersions != null) {
            clone.testVersions = new ArrayList<String>(this.testVersions);
        }
    }
}

