/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.targetplatforms.core.descriptors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.nuxeo.common.xmap.DOMSerializer;
import org.nuxeo.common.xmap.annotation.XContent;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.w3c.dom.DocumentFragment;

public class TargetDescriptor {
    private static final Log log = LogFactory.getLog(TargetDescriptor.class);
    @XNode(value="@id")
    String id;
    @XNode(value="@enabled")
    Boolean enabled;
    @XNode(value="@restricted")
    Boolean restricted;
    @XNode(value="@deprecated")
    Boolean deprecated;
    @XNode(value="@parent")
    String parent;
    @XNode(value="name")
    String name;
    @XNode(value="version")
    String version;
    @XNode(value="refVersion")
    String refVersion;
    @XNode(value="label")
    String label;
    @XNode(value="status")
    String status;
    @XNode(value="releaseDate")
    String releaseDate;
    @XNode(value="endOfAvailability")
    String endOfAvailability;
    @XNode(value="downloadLink")
    String downloadLink;
    String description;
    @XNodeList(value="types/type", type=ArrayList.class, componentType=String.class)
    List<String> types;

    @XContent(value="description")
    public void setDescription(DocumentFragment descriptionDOM) {
        try {
            OutputFormat of = new OutputFormat();
            of.setOmitXMLDeclaration(true);
            this.description = DOMSerializer.toString((DocumentFragment)descriptionDOM, (OutputFormat)of).trim();
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public boolean isEnableSet() {
        return this.enabled != null;
    }

    public boolean isEnabled() {
        return this.enabled == null || Boolean.TRUE.equals(this.enabled);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRestricted() {
        return this.restricted != null && Boolean.TRUE.equals(this.restricted);
    }

    public boolean isDeprecated() {
        return this.deprecated != null && Boolean.TRUE.equals(this.deprecated);
    }

    public String getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRefVersion() {
        return this.refVersion;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStatus() {
        return this.status;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public String getEndOfAvailability() {
        return this.endOfAvailability;
    }

    public String getDownloadLink() {
        return this.downloadLink;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public boolean matchesType(String type) {
        if (this.types == null) {
            return false;
        }
        return this.types.contains(type);
    }

    public TargetDescriptor clone() {
        TargetDescriptor clone = new TargetDescriptor();
        this.doClone(clone);
        return this.clone();
    }

    protected void doClone(TargetDescriptor clone) {
        clone.id = this.id;
        clone.enabled = this.enabled;
        clone.restricted = this.restricted;
        clone.deprecated = this.deprecated;
        clone.parent = this.parent;
        clone.name = this.name;
        clone.version = this.version;
        clone.refVersion = this.refVersion;
        clone.label = this.label;
        clone.status = this.status;
        clone.releaseDate = this.releaseDate;
        clone.endOfAvailability = this.endOfAvailability;
        clone.downloadLink = this.downloadLink;
        clone.description = this.description;
        if (this.types != null) {
            clone.types = new ArrayList<String>(this.types);
        }
    }
}

