/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.samples.importer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentTransformer;
import org.nuxeo.ecm.core.io.DocumentTranslationMap;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.samples.importer.TemplateBundleActivator;
import org.nuxeo.template.samples.importer.XMLModelReader;

public class ModelImporter {
    protected static final Log log = LogFactory.getLog(ModelImporter.class);
    private static final String TEMPLATE_SAMPLE_INIT_EVENT = "TemplateSampleInit";
    private static final String[] IMPORT_ALREADY_DONE_EVENTS = new String[]{"TemplateSampleInit"};
    public static final String EXAMPLE_ROOT = "example";
    public static final String TEST_EXAMPLE_ROOT = "testexample";
    public static final String TEMPLATE_ROOT = "template";
    public static final String TEST_TEMPLATE_ROOT = "testtemplate";
    protected static final String RESOURCES_ROOT = "templatesamples";
    protected static final String RAW_RESOURCES_ROOT = "rawsamples";
    protected static final String DOMAIN_QUERY = "select * from Domain where ecm:isCheckedInVersion=0  AND  ecm:currentLifeCycleState != 'deleted' order by dc:created ASC";
    protected final CoreSession session;

    public ModelImporter(CoreSession session) {
        this.session = session;
    }

    protected String getTemplateResourcesRootPath() {
        return RESOURCES_ROOT;
    }

    protected String getRawTemplateResourcesRootPath() {
        return RAW_RESOURCES_ROOT;
    }

    protected DocumentModel getTargetDomain() {
        return this.getTargetDomain(true);
    }

    protected DocumentModel getTargetDomain(boolean canRetry) {
        DocumentModelList domains = this.session.query(DOMAIN_QUERY);
        if (domains.size() > 0) {
            return (DocumentModel)domains.get(0);
        }
        if (canRetry) {
            this.session.save();
            return this.getTargetDomain(false);
        }
        return null;
    }

    protected DocumentModel getOrCreateTemplateContainer() {
        DocumentModelList roots;
        DocumentModel rootDomain = this.getTargetDomain();
        if (rootDomain != null && (roots = this.session.getChildren(rootDomain.getRef(), "TemplateRoot")).size() > 0) {
            return (DocumentModel)roots.get(0);
        }
        return null;
    }

    protected DocumentModel getWSRoot(DocumentModel rootDomain) {
        DocumentModelList roots;
        if (rootDomain != null && (roots = this.session.getChildren(rootDomain.getRef(), "WorkspaceRoot")).size() > 0) {
            DocumentModel WSRoot = (DocumentModel)roots.get(0);
            return WSRoot;
        }
        return null;
    }

    protected DocumentModel getOrCreateSampleContainer() {
        DocumentModel rootDomain = this.getTargetDomain();
        DocumentModel container = null;
        DocumentModel WSRoot = this.getWSRoot(rootDomain);
        if (WSRoot != null) {
            PathRef targetPath = new PathRef(WSRoot.getPathAsString() + "/" + this.getTemplateResourcesRootPath());
            if (!this.session.exists((DocumentRef)targetPath)) {
                container = this.session.createDocumentModel(WSRoot.getPathAsString(), this.getTemplateResourcesRootPath(), "nxtrSamplesContainer");
                container.setPropertyValue("dc:title", (Serializable)((Object)"Discover Customization Examples"));
                container.setPropertyValue("nxtplsamplescontainer:instructions", (Serializable)((Object)"<span class=\"nxtrExplanations\">The BigCorp company uses Nuxeo Studio and template rendering to generate custom project portfolios that showcase relevant expertise to potential new clients.<br /><br /><strong>It's your turn now! Open the \"BigCorp Transforms GreatBank Customer Service\" project</strong> and follow the instructions.</span>"));
                container = this.session.createDocument(container);
            } else {
                container = this.session.getDocument((DocumentRef)targetPath);
            }
        }
        return container;
    }

    private DocumentModel getOrCreateTestSamplesContainer() {
        DocumentModel container = null;
        DocumentModel parentContainer = this.getOrCreateSampleContainer();
        PathRef targetPath = new PathRef(this.getOrCreateSampleContainer().getPathAsString() + "/" + this.getRawTemplateResourcesRootPath());
        if (!this.session.exists((DocumentRef)targetPath)) {
            container = this.session.createDocumentModel(parentContainer.getPathAsString(), RAW_RESOURCES_ROOT, "Workspace");
            container.setPropertyValue("dc:title", (Serializable)((Object)"More (Raw) Examples"));
            container.setPropertyValue("dc:description", (Serializable)((Object)"This space contains raw examples to demonstrate the Nuxeo template rendering add-on's advanced possibilities. Go to the \"Discover Customization Samples\" folder first if you did not follow its instructions yet."));
            container = this.session.createDocument(container);
        } else {
            container = this.session.getDocument((DocumentRef)targetPath);
        }
        return container;
    }

    protected boolean isImportAlreadyDone() {
        if (Framework.isTestModeSet()) {
            return false;
        }
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        List entries = reader.queryLogs(IMPORT_ALREADY_DONE_EVENTS, null);
        return !entries.isEmpty();
    }

    protected void markImportDone() {
        if (Framework.isTestModeSet()) {
            return;
        }
        AuditLogger writer = (AuditLogger)Framework.getService(AuditLogger.class);
        LogEntry entry = writer.newLogEntry();
        entry.setEventId(TEMPLATE_SAMPLE_INIT_EVENT);
        entry.setEventDate(Calendar.getInstance().getTime());
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        entries.add(entry);
        writer.addLogEntries(entries);
    }

    public int importModels() {
        File[] modelRoots;
        if (this.isImportAlreadyDone()) {
            return 0;
        }
        int nbImportedDocs = 0;
        Path path = TemplateBundleActivator.getDataDirPath();
        File root = new File((path = path.append(this.getTemplateResourcesRootPath())).toString());
        if (root.exists() && (modelRoots = root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) != null && modelRoots.length > 0) {
            for (File modelRoot : modelRoots) {
                log.info((Object)("Importing template from " + modelRoot.getAbsolutePath()));
                try {
                    nbImportedDocs += this.importModelAndExamples(modelRoot);
                }
                catch (IOException e) {
                    throw new NuxeoException("Failed to import from template: " + modelRoot.getAbsolutePath(), (Throwable)e);
                }
            }
            this.markImportDone();
        }
        return nbImportedDocs;
    }

    public int importModelAndExamples(File root) throws IOException {
        int nbImportedDocs = 0;
        final HashMap roots = new HashMap();
        root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    return false;
                }
                if (file.getName().equals(ModelImporter.TEMPLATE_ROOT)) {
                    roots.put(ModelImporter.TEMPLATE_ROOT, file);
                    return true;
                }
                if (file.getName().equals(ModelImporter.TEST_TEMPLATE_ROOT) && Framework.isTestModeSet()) {
                    roots.put(ModelImporter.TEMPLATE_ROOT, file);
                    return true;
                }
                if (file.getName().equals(ModelImporter.EXAMPLE_ROOT)) {
                    roots.put(ModelImporter.EXAMPLE_ROOT, file);
                    return true;
                }
                if (file.getName().equals(ModelImporter.TEST_EXAMPLE_ROOT) && Framework.isTestModeSet()) {
                    roots.put(ModelImporter.TEST_EXAMPLE_ROOT, file);
                    return true;
                }
                return false;
            }
        });
        if (roots.size() >= 1 && roots.get(TEMPLATE_ROOT) != null) {
            DocumentModel templatesContainer = this.getOrCreateTemplateContainer();
            DocumentModel samplesContainer = this.getOrCreateSampleContainer();
            DocumentModel testSamplesContainer = null;
            if (Framework.isTestModeSet()) {
                testSamplesContainer = this.getOrCreateTestSamplesContainer();
            }
            if (templatesContainer != null) {
                DocumentRef modelRef = this.importModel(root.getName(), (File)roots.get(TEMPLATE_ROOT), templatesContainer);
                ++nbImportedDocs;
                if (samplesContainer != null) {
                    if (roots.get(EXAMPLE_ROOT) != null) {
                        nbImportedDocs += this.importSamples((File)roots.get(EXAMPLE_ROOT), modelRef, samplesContainer);
                    }
                    if (roots.get(TEST_EXAMPLE_ROOT) != null && Framework.isTestModeSet()) {
                        nbImportedDocs += this.importSamples((File)roots.get(TEST_EXAMPLE_ROOT), modelRef, testSamplesContainer);
                    }
                }
            }
        }
        return nbImportedDocs;
    }

    protected DocumentRef importModel(String modelName, File source, DocumentModel root) throws IOException {
        XMLModelReader reader = new XMLModelReader(source, modelName);
        DocumentModelWriter writer = new DocumentModelWriter(this.session, root.getPathAsString());
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        pipe.setReader((DocumentReader)reader);
        pipe.setWriter((DocumentWriter)writer);
        DocumentTranslationMap map = pipe.run();
        DocumentRef ref = (DocumentRef)map.getDocRefMap().values().iterator().next();
        this.session.save();
        return ref;
    }

    protected int importSamples(File root, DocumentRef modelRef, DocumentModel rootDoc) throws IOException {
        int nbImportedDocs = 0;
        for (File exampleDir : root.listFiles()) {
            if (!exampleDir.isDirectory()) continue;
            XMLModelReader reader = new XMLModelReader(exampleDir, exampleDir.getName());
            DocumentModelWriter writer = new DocumentModelWriter(this.session, rootDoc.getPathAsString());
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            final String targetUUID = modelRef.toString();
            pipe.addTransformer(new DocumentTransformer(){

                public boolean transform(ExportedDocument xdoc) throws IOException {
                    xdoc.getDocument().accept(new Visitor(){

                        public void visit(Text node) {
                        }

                        public void visit(ProcessingInstruction node) {
                        }

                        public void visit(Namespace namespace) {
                        }

                        public void visit(Entity node) {
                        }

                        public void visit(Comment node) {
                        }

                        public void visit(CDATA node) {
                        }

                        public void visit(Attribute node) {
                        }

                        public void visit(Element node) {
                            if ("templateId".equalsIgnoreCase(node.getName()) && "templateEntry".equalsIgnoreCase(node.getParent().getName())) {
                                log.debug((Object)("Translating uuid to " + targetUUID));
                                node.setText(targetUUID);
                            }
                        }

                        public void visit(DocumentType documentType) {
                        }

                        public void visit(Document document) {
                        }
                    });
                    return true;
                }
            });
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
            ++nbImportedDocs;
        }
        this.session.save();
        return nbImportedDocs;
    }
}

