/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.samples.importer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class TemplateBundleActivator
implements BundleActivator {
    private BundleContext context;
    protected static final Log log = LogFactory.getLog(TemplateBundleActivator.class);
    private static File tmpDir;
    private static String dataDirPath;

    protected static String getTemplateResourcesRootPath() {
        return "templatesamples";
    }

    public URL getResource(String path) {
        return this.context.getBundle().getResource(path);
    }

    public Enumeration<?> findEntries(String path) {
        return this.context.getBundle().findEntries(path, null, true);
    }

    public BundleContext getContext() {
        return this.context;
    }

    public void start(BundleContext context) {
        this.context = context;
        TemplateBundleActivator.initDataDirPath();
        this.expandResources();
    }

    public void stop(BundleContext context) {
        this.context = null;
        TemplateBundleActivator.cleanupDataDirPath();
    }

    protected static void initDataDirPath() {
        if (dataDirPath != null) {
            return;
        }
        String dataDir = Environment.getDefault().getData().getPath();
        Path path = new Path(dataDir);
        path = path.append("resources");
        dataDirPath = path.toString();
    }

    protected static void cleanupDataDirPath() {
        if (tmpDir != null) {
            FileUtils.deleteQuietly((File)tmpDir);
            tmpDir = null;
        }
        dataDirPath = null;
    }

    protected static Path getDataDirPath() {
        return new Path(dataDirPath);
    }

    public void expandResources() {
        log.info((Object)("Deploying templates for bundle " + this.context.getBundle().getSymbolicName()));
        URL sampleRootURL = this.getResource(TemplateBundleActivator.getTemplateResourcesRootPath());
        if (sampleRootURL == null) {
            return;
        }
        Path path = TemplateBundleActivator.getDataDirPath();
        File dataDir = new File((path = path.append(TemplateBundleActivator.getTemplateResourcesRootPath())).toString());
        if (!dataDir.exists()) {
            dataDir.mkdirs();
        }
        Enumeration<?> urls = this.findEntries(TemplateBundleActivator.getTemplateResourcesRootPath());
        while (urls.hasMoreElements()) {
            URL resourceURL = (URL)urls.nextElement();
            try {
                InputStream is = resourceURL.openStream();
                Throwable throwable = null;
                try {
                    String filePath = resourceURL.getFile();
                    filePath = filePath.split("/" + TemplateBundleActivator.getTemplateResourcesRootPath() + "/")[1];
                    filePath = "/" + filePath;
                    File f = new File(dataDir, filePath);
                    File parent = f.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)f);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (IOException e) {
                throw new NuxeoException("Failed for template: " + resourceURL, (Throwable)e);
            }
        }
    }
}

