/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.url;

import java.io.Serializable;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.annotations.In;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

public abstract class AbstractRenditionRestHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;

    protected abstract Blob renderAsBlob(DocumentModel var1, String var2) throws Exception;

    public void render(DocumentView docView) throws Exception {
        DocumentModel doc;
        DocumentLocation docLoc = docView.getDocumentLocation();
        if (this.documentManager == null) {
            RepositoryLocation loc = new RepositoryLocation(docLoc.getServerName());
            this.navigationContext.setCurrentServerLocation(loc);
            this.documentManager = this.navigationContext.getOrCreateDocumentManager();
        }
        if ((doc = this.documentManager.getDocument(docLoc.getDocRef())) != null) {
            String renditionName = docView.getViewId();
            FacesContext context = FacesContext.getCurrentInstance();
            Blob rendered = this.renderAsBlob(doc, renditionName);
            if (rendered != null) {
                if (rendered.getMimeType() != null && rendered.getMimeType().startsWith("text/")) {
                    HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
                    request.setAttribute("inline", (Object)"true");
                }
                ComponentUtils.download((FacesContext)context, (Blob)rendered, (String)rendered.getFilename());
            } else {
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                response.sendError(404, "Unable to find rendition " + renditionName);
            }
        }
    }
}

