/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.web;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.ProcessState;
import fr.opensagres.xdocreport.document.registry.TemplateEngineInitializerRegistry;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.document.web.XDocBaseServletConstants;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.registry.TemplateEngineRegistry;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class BaseXDocReportServlet
extends HttpServlet
implements XDocBaseServletConstants {
    private static final long serialVersionUID = -5890298276937085849L;
    private static final String SAT_6_MAY_1995_12_00_00_GMT = "Sat, 6 May 1995 12:00:00 GMT";
    private static final String EXPIRES = "Expires";
    private static final String POST_CHECK_0_PRE_CHECK_0 = "post-check=0, pre-check=0";
    private static final String NO_CACHE = "no-cache";
    private static final String PRAGMA = "Pragma";
    private static final String NO_STORE_NO_CACHE_MUST_REVALIDATE = "no-store, no-cache, must-revalidate";
    private static final String CACHE_CONTROL_HTTP_HEADER = "Cache-Control";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final String ATTACHMENT_FILENAME = "attachment; filename=\"";
    private String encoding;
    private boolean forceEncoding;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.encoding = config.getInitParameter("encoding");
        this.forceEncoding = StringUtils.asBoolean((String)config.getInitParameter("forceEncoding"), (boolean)false);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.prepareHTTPRequest(request);
        this.processRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.prepareHTTPRequest(request);
        this.processRequest(request, response);
    }

    private void prepareHTTPRequest(HttpServletRequest request) throws UnsupportedEncodingException {
        if (this.encoding != null && (this.forceEncoding || request.getCharacterEncoding() == null)) {
            request.setCharacterEncoding(this.encoding);
        }
    }

    protected String getDispatchParameter(HttpServletRequest request) {
        return request.getParameter("dispatch");
    }

    protected String getReportId(HttpServletRequest request) {
        return request.getParameter("reportId");
    }

    protected ProcessState getProcessState(HttpServletRequest request) {
        String state = request.getParameter("processState");
        if (ProcessState.ORIGINAL.name().equalsIgnoreCase(state)) {
            return ProcessState.ORIGINAL;
        }
        if (ProcessState.PREPROCESSED.name().equalsIgnoreCase(state)) {
            return ProcessState.PREPROCESSED;
        }
        if (ProcessState.GENERATED.name().equalsIgnoreCase(state)) {
            return ProcessState.GENERATED;
        }
        return null;
    }

    protected String getEntryName(HttpServletRequest request) {
        return request.getParameter("entryName");
    }

    protected String getTemplateEngineKind(String reportId, HttpServletRequest request) {
        return this.getTemplateEngineKind(request);
    }

    protected String getTemplateEngineKind(HttpServletRequest request) {
        return request.getParameter("templateEngineKind");
    }

    protected String getTemplateEngineId(HttpServletRequest request) {
        return request.getParameter("templateEngineId");
    }

    protected ITemplateEngine getTemplateEngine(String reportId, HttpServletRequest request) {
        return this.getTemplateEngine(request);
    }

    protected ITemplateEngine getTemplateEngine(IXDocReport report, HttpServletRequest request) {
        String documentKind = report.getKind();
        String templateEngineKind = this.getTemplateEngineKind(request);
        ITemplateEngine templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, documentKind);
        if (templateEngine == null) {
            templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, null);
        }
        return templateEngine;
    }

    protected ITemplateEngine getTemplateEngine(HttpServletRequest request) {
        String templateEngineId = this.getTemplateEngineId(request);
        if (StringUtils.isNotEmpty((String)templateEngineId)) {
            return TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineId);
        }
        return TemplateEngineRegistry.getRegistry().getDefaultTemplateEngine();
    }

    protected XDocReportRegistry getRegistry(HttpServletRequest request) {
        return XDocReportRegistry.getRegistry();
    }

    protected XDocReportRegistry getRegistryFromHTTPSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        XDocReportRegistry registry = (XDocReportRegistry)session.getAttribute("XDocReportRegistry_session");
        if (registry == null) {
            registry = new XDocReportRegistry();
            session.setAttribute("XDocReportRegistry_session", (Object)registry);
        }
        return registry;
    }

    protected void clearRegistryFromHTTPSession(HttpServletRequest request) {
        HttpSession session = request.getSession();
        session.removeAttribute("XDocReportRegistry_session");
    }

    protected void disableHTTPResponCache(HttpServletResponse response) {
        response.setHeader(EXPIRES, SAT_6_MAY_1995_12_00_00_GMT);
        response.setHeader(CACHE_CONTROL_HTTP_HEADER, NO_STORE_NO_CACHE_MUST_REVALIDATE);
        response.addHeader(CACHE_CONTROL_HTTP_HEADER, POST_CHECK_0_PRE_CHECK_0);
        response.setHeader(PRAGMA, NO_CACHE);
    }

    protected void prepareHTTPResponse(String reportId, MimeMapping mimeMapping, HttpServletRequest request, HttpServletResponse response) {
        String contentDisposition;
        if (mimeMapping != null) {
            response.setContentType(mimeMapping.getMimeType());
        }
        if (this.isGenerateContentDisposition(reportId, mimeMapping, request) && StringUtils.isNotEmpty((String)(contentDisposition = this.getContentDisposition(reportId, mimeMapping, request)))) {
            response.setHeader(CONTENT_DISPOSITION_HEADER, contentDisposition.toString());
        }
        if (this.isDisableHTTPResponCache()) {
            this.disableHTTPResponCache(response);
        }
    }

    protected void prepareHTTPResponse(String reportId, String entryName, HttpServletRequest request, HttpServletResponse response) {
        String contentDisposition;
        if (this.isGenerateContentDisposition(reportId, null, request) && StringUtils.isNotEmpty((String)(contentDisposition = this.getContentDisposition(entryName)))) {
            response.setHeader(CONTENT_DISPOSITION_HEADER, contentDisposition.toString());
        }
        if (this.isDisableHTTPResponCache()) {
            this.disableHTTPResponCache(response);
        }
    }

    protected boolean isDisableHTTPResponCache() {
        return true;
    }

    protected boolean isGenerateContentDisposition(String reportId, MimeMapping mimeMapping, HttpServletRequest request) {
        return true;
    }

    protected String getContentDisposition(String reportId, MimeMapping mimeMapping, HttpServletRequest request) {
        if (mimeMapping != null) {
            String fileName = mimeMapping.formatFileName(reportId);
            return this.getContentDisposition(fileName);
        }
        return null;
    }

    protected String getContentDisposition(String fileName) {
        StringBuilder contentDisposition = new StringBuilder(ATTACHMENT_FILENAME);
        contentDisposition.append(fileName);
        contentDisposition.append("\"");
        return contentDisposition.toString();
    }

    protected abstract void processRequest(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
}

