/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.processors.fm;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.fm.FMContextBuilder;
import org.nuxeo.template.fm.FreeMarkerVariableExtractor;
import org.nuxeo.template.processors.AbstractTemplateProcessor;
import org.nuxeo.template.processors.fm.FMBindingResolver;

public class FreeMarkerProcessor
extends AbstractTemplateProcessor
implements TemplateProcessor {
    protected StringTemplateLoader loader = new StringTemplateLoader();
    protected FreemarkerEngine fmEngine = null;
    protected FMContextBuilder fmContextBuilder = new FMContextBuilder();

    protected FreemarkerEngine getEngine() {
        if (this.fmEngine == null) {
            this.fmEngine = new FreemarkerEngine();
            this.fmEngine.getConfiguration().setTemplateLoader((TemplateLoader)this.loader);
        }
        return this.fmEngine;
    }

    public Blob renderTemplate(TemplateBasedDocument templateBasedDocument, String templateName) throws Exception {
        Blob sourceTemplateBlob = this.getSourceTemplateBlob(templateBasedDocument, templateName);
        String fmTemplateKey = "main" + System.currentTimeMillis();
        String ftl = sourceTemplateBlob.getString();
        this.loader.putTemplate(fmTemplateKey, ftl);
        Map<String, Object> ctx = this.fmContextBuilder.build(templateBasedDocument, templateName);
        FMBindingResolver resolver = new FMBindingResolver();
        resolver.resolve(templateBasedDocument.getParams(templateName), ctx, templateBasedDocument);
        StringWriter writer = new StringWriter();
        this.getEngine().render(fmTemplateKey, ctx, (Writer)writer);
        StringBlob result = new StringBlob(writer.toString());
        result.setMimeType("text/html");
        String targetFileName = FileUtils.getFileNameNoExt((String)templateBasedDocument.getAdaptedDoc().getTitle());
        result.setFilename(targetFileName + ".html");
        return result;
    }

    public List<TemplateInput> getInitialParametersDefinition(Blob blob) throws Exception {
        String xmlContent;
        ArrayList<TemplateInput> params = new ArrayList<TemplateInput>();
        if (blob != null && (xmlContent = blob.getString()) != null) {
            List<String> vars = FreeMarkerVariableExtractor.extractVariables(xmlContent);
            for (String var : vars) {
                TemplateInput input = new TemplateInput(var);
                params.add(input);
            }
        }
        return params;
    }
}

