/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.fm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;

public class FreeMarkerVariableExtractor {
    protected static final Pattern simpleVariableMatcher = Pattern.compile("\\$\\{([^\\}]*)\\}");
    protected static final String[] spliters = new String[]{".", "?", "=", ">", "<", "!", " ", "["};
    protected static final Pattern[] directiveMatchers = new Pattern[]{Pattern.compile("\\[\\#if\\s([^\\]]*)\\]"), Pattern.compile("\\[\\#list\\s[\\d\\.\\.]*(.+)\\sas\\s([^\\]]*)\\]")};
    protected static final Pattern[] assignMatchers = new Pattern[]{Pattern.compile("\\[\\#assign\\s(.+)=.*\\]")};
    protected static final List<String> reservedContextKeywords = new ArrayList<String>();
    protected static final String[] freeMarkerVariableSuffix = new String[]{"_index", "_has_next"};

    protected static String extractVariableName(String match) {
        String varName = match.trim();
        if (varName.startsWith("!")) {
            varName = varName.substring(1);
        }
        while (varName.startsWith("(")) {
            varName = varName.substring(1);
        }
        int idx = varName.indexOf(".");
        if (idx > 1) {
            varName = varName.substring(0, idx);
        }
        for (String spliter : spliters) {
            idx = varName.indexOf(spliter);
            if (idx <= 1) continue;
            varName = varName.substring(0, idx);
        }
        return varName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetReservedContextKeywords() {
        List<String> list = reservedContextKeywords;
        synchronized (list) {
            reservedContextKeywords.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getreservedContextKeywords() {
        List<String> list = reservedContextKeywords;
        synchronized (list) {
            TemplateProcessorService tps;
            if (reservedContextKeywords.size() == 0 && (tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class)) != null) {
                reservedContextKeywords.addAll(tps.getReservedContextKeywords());
            }
        }
        return reservedContextKeywords;
    }

    public static List<String> extractVariables(String content) {
        String v;
        Matcher dmatcher;
        ArrayList<String> variables = new ArrayList<String>();
        ArrayList<String> blackListedVariables = new ArrayList<String>();
        if (content.length() > 10000) {
            content = content.replaceAll("</", "\n</");
        }
        Matcher matcher = simpleVariableMatcher.matcher(content);
        matcher.matches();
        while (matcher.find()) {
            String v2;
            if (matcher.groupCount() <= 0 || variables.contains(v2 = FreeMarkerVariableExtractor.extractVariableName(matcher.group(1)))) continue;
            variables.add(v2);
        }
        for (Pattern dPattern : directiveMatchers) {
            dmatcher = dPattern.matcher(content);
            dmatcher.matches();
            while (dmatcher.find()) {
                if (dmatcher.groupCount() <= 0) continue;
                v = FreeMarkerVariableExtractor.extractVariableName(dmatcher.group(1));
                if (!variables.contains(v)) {
                    variables.add(v);
                }
                if (dmatcher.groupCount() <= 1) continue;
                String localVariable = FreeMarkerVariableExtractor.extractVariableName(dmatcher.group(2));
                blackListedVariables.add(localVariable);
                for (String suffix : freeMarkerVariableSuffix) {
                    blackListedVariables.add(localVariable + suffix);
                }
            }
        }
        for (Pattern dPattern : assignMatchers) {
            dmatcher = dPattern.matcher(content);
            dmatcher.matches();
            while (dmatcher.find()) {
                if (dmatcher.groupCount() <= 0) continue;
                v = FreeMarkerVariableExtractor.extractVariableName(dmatcher.group(1));
                blackListedVariables.add(FreeMarkerVariableExtractor.extractVariableName(v));
            }
        }
        for (String bVar : blackListedVariables) {
            variables.remove(bVar);
        }
        for (String bVar : FreeMarkerVariableExtractor.getreservedContextKeywords()) {
            variables.remove(bVar);
        }
        ListIterator<String> varIter = variables.listIterator();
        while (varIter.hasNext()) {
            String var = (String)varIter.next();
            if (var.contains("<") || var.contains(">")) {
                varIter.remove();
                continue;
            }
            if (!var.contains("\n")) continue;
            varIter.set(var.replaceAll("\n", "").trim());
        }
        return variables;
    }
}

