/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.adapters.source;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.XMLSerializer;
import org.nuxeo.template.adapters.AbstractTemplateDocument;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessor;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateSourceDocumentAdapterImpl
extends AbstractTemplateDocument
implements Serializable,
TemplateSourceDocument {
    public static final String TEMPLATE_DATA_PROP = "tmpl:templateData";
    public static final String TEMPLATE_NAME_PROP = "tmpl:templateName";
    public static final String TEMPLATE_TYPE_PROP = "tmpl:templateType";
    public static final String TEMPLATE_TYPE_AUTO = "auto";
    public static final String TEMPLATE_APPLICABLE_TYPES_PROP = "tmpl:applicableTypes";
    public static final String TEMPLATE_APPLICABLE_TYPES_ALL = "all";
    public static final String TEMPLATE_FORCED_TYPES_PROP = "tmpl:forcedTypes";
    public static final String TEMPLATE_FORCED_TYPES_NONE = "none";
    public static final String TEMPLATE_RENDITION_NONE = "none";
    public static final String TEMPLATE_OUTPUT_PROP = "tmpl:outputFormat";
    public static final String TEMPLATE_OVERRIDE_PROP = "tmpl:allowOverride";
    public static final String TEMPLATE_USEASMAIN_PROP = "tmpl:useAsMainContent";
    public static final String TEMPLATE_RENDITION_PROP = "tmpl:targetRenditionName";
    public static final String TEMPLATE_FACET = "Template";
    private static final long serialVersionUID = 1L;

    public TemplateSourceDocumentAdapterImpl(DocumentModel doc) {
        this.adaptedDoc = doc;
    }

    protected String getTemplateParamsXPath() {
        return TEMPLATE_DATA_PROP;
    }

    public List<TemplateInput> getParams() throws ClientException {
        String dataPath = this.getTemplateParamsXPath();
        if (this.adaptedDoc.getPropertyValue(dataPath) == null) {
            return new ArrayList<TemplateInput>();
        }
        String xml = this.adaptedDoc.getPropertyValue(dataPath).toString();
        try {
            return XMLSerializer.readFromXml(xml);
        }
        catch (Exception e) {
            log.error((Object)"Unable to parse parameters", (Throwable)e);
            return new ArrayList<TemplateInput>();
        }
    }

    public boolean hasEditableParams() throws ClientException {
        for (TemplateInput param : this.getParams()) {
            if (param.isReadOnly()) continue;
            return true;
        }
        return false;
    }

    public DocumentModel saveParams(List<TemplateInput> params, boolean save) throws Exception {
        String dataPath = this.getTemplateParamsXPath();
        String xml = XMLSerializer.serialize(params);
        this.adaptedDoc.setPropertyValue(dataPath, (Serializable)((Object)xml));
        if (save) {
            this.doSave();
        }
        return this.adaptedDoc;
    }

    protected TemplateProcessor getTemplateProcessor() {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        return tps.getProcessor(this.getTemplateType());
    }

    public String getParamsAsString() throws PropertyException, ClientException {
        String dataPath = this.getTemplateParamsXPath();
        if (this.adaptedDoc.getPropertyValue(dataPath) == null) {
            return null;
        }
        return this.adaptedDoc.getPropertyValue(dataPath).toString();
    }

    public List<TemplateInput> addInput(TemplateInput input) throws Exception {
        List<TemplateInput> params = this.getParams();
        if (input == null) {
            return params;
        }
        boolean newParam = true;
        if (params == null) {
            params = new ArrayList<TemplateInput>();
        }
        for (TemplateInput param : params) {
            if (!param.getName().equals(input.getName())) continue;
            newParam = false;
            param.update(input);
            break;
        }
        if (newParam) {
            params.add(input);
        }
        this.saveParams(params, false);
        return params;
    }

    public String getTemplateType() {
        try {
            String ttype = (String)((Object)this.getAdaptedDoc().getPropertyValue(TEMPLATE_TYPE_PROP));
            if (TEMPLATE_TYPE_AUTO.equals(ttype)) {
                return null;
            }
            return ttype;
        }
        catch (Exception e) {
            log.error((Object)"Unable to read template type ", (Throwable)e);
            return null;
        }
    }

    public void initTemplate(boolean save) throws Exception {
        Blob blob;
        if (this.getAdaptedDoc().getContextData("TEMPLATE_INIT_DONE") == null && (blob = this.getTemplateBlob()) != null) {
            TemplateProcessor processor;
            String tmplName;
            TemplateProcessorService tps;
            String templateType;
            if (this.getTemplateType() == null && (templateType = (tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class)).findProcessorName(blob)) != null) {
                this.getAdaptedDoc().setPropertyValue(TEMPLATE_TYPE_PROP, (Serializable)((Object)templateType));
            }
            if ((tmplName = (String)((Object)this.getAdaptedDoc().getPropertyValue(TEMPLATE_NAME_PROP))) == null || tmplName.isEmpty()) {
                tmplName = this.computeTemplateName();
                this.getAdaptedDoc().setPropertyValue(TEMPLATE_NAME_PROP, (Serializable)((Object)tmplName));
            }
            if ((processor = this.getTemplateProcessor()) != null) {
                List params = processor.getInitialParametersDefinition(blob);
                this.saveParams(params, save);
            }
            this.getAdaptedDoc().getContextData().put((Object)"TEMPLATE_INIT_DONE", (Object)true);
        }
    }

    protected String computeTemplateName() throws ClientException {
        return this.getAdaptedDoc().getTitle();
    }

    public boolean allowInstanceOverride() {
        try {
            Boolean allowOverride = (Boolean)this.getAdaptedDoc().getPropertyValue(TEMPLATE_OVERRIDE_PROP);
            if (allowOverride == null) {
                allowOverride = true;
            }
            return allowOverride;
        }
        catch (Exception e) {
            log.error((Object)"Unable to read template allow override ", (Throwable)e);
            return false;
        }
    }

    public void initTypesBindings() throws Exception {
        String[] applicableTypesArray = (String[])this.getAdaptedDoc().getPropertyValue(TEMPLATE_APPLICABLE_TYPES_PROP);
        String[] newApplicableTypesArray = null;
        if (applicableTypesArray == null || applicableTypesArray.length == 0) {
            newApplicableTypesArray = new String[]{TEMPLATE_APPLICABLE_TYPES_ALL};
        } else if (applicableTypesArray.length > 1 && TEMPLATE_APPLICABLE_TYPES_ALL.equals(applicableTypesArray[0])) {
            List<String> at = Arrays.asList(applicableTypesArray);
            at.remove(0);
            newApplicableTypesArray = at.toArray(new String[at.size()]);
        }
        if (newApplicableTypesArray != null) {
            this.getAdaptedDoc().setPropertyValue(TEMPLATE_APPLICABLE_TYPES_PROP, (Serializable)newApplicableTypesArray);
        }
        String[] forcedTypesArray = (String[])this.getAdaptedDoc().getPropertyValue(TEMPLATE_FORCED_TYPES_PROP);
        String[] newForcedTypesArray = null;
        if (forcedTypesArray == null || forcedTypesArray.length == 0) {
            newForcedTypesArray = new String[]{"none"};
        } else if (forcedTypesArray.length > 1 && "none".equals(forcedTypesArray[0])) {
            List<String> ft = Arrays.asList(forcedTypesArray);
            ft.remove(0);
            newForcedTypesArray = ft.toArray(new String[ft.size()]);
        }
        if (newForcedTypesArray != null) {
            this.getAdaptedDoc().setPropertyValue(TEMPLATE_FORCED_TYPES_PROP, (Serializable)newForcedTypesArray);
        }
    }

    public List<String> getApplicableTypes() {
        try {
            String[] applicableTypesArray = (String[])this.getAdaptedDoc().getPropertyValue(TEMPLATE_APPLICABLE_TYPES_PROP);
            ArrayList<String> applicableTypes = new ArrayList<String>();
            if (applicableTypesArray != null) {
                applicableTypes.addAll(Arrays.asList(applicableTypesArray));
            }
            if (applicableTypes.size() > 0 && ((String)applicableTypes.get(0)).equals(TEMPLATE_APPLICABLE_TYPES_ALL)) {
                applicableTypes.remove(0);
            }
            return applicableTypes;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading applicable types");
            return new ArrayList<String>();
        }
    }

    public List<String> getForcedTypes() {
        try {
            String[] forcedTypesArray = (String[])this.getAdaptedDoc().getPropertyValue(TEMPLATE_FORCED_TYPES_PROP);
            ArrayList<String> applicableTypes = new ArrayList<String>();
            if (forcedTypesArray != null) {
                applicableTypes.addAll(Arrays.asList(forcedTypesArray));
            }
            if (applicableTypes.size() > 0 && ((String)applicableTypes.get(0)).equals("none")) {
                applicableTypes.remove(0);
            }
            return applicableTypes;
        }
        catch (Exception e) {
            log.error((Object)"Error while reading applicable types");
            return new ArrayList<String>();
        }
    }

    public void removeForcedType(String type, boolean save) throws ClientException {
        List<String> types = this.getForcedTypes();
        if (types.contains(type)) {
            types.remove(type);
            String[] typesArray = types.toArray(new String[types.size()]);
            this.getAdaptedDoc().setPropertyValue(TEMPLATE_FORCED_TYPES_PROP, (Serializable)typesArray);
            if (save) {
                this.adaptedDoc = this.getAdaptedDoc().getCoreSession().saveDocument(this.getAdaptedDoc());
            }
        }
    }

    public void setForcedTypes(String[] forcedTypes, boolean save) throws ClientException {
        this.getAdaptedDoc().setPropertyValue(TEMPLATE_FORCED_TYPES_PROP, (Serializable)forcedTypes);
        if (save) {
            this.adaptedDoc = this.getAdaptedDoc().getCoreSession().saveDocument(this.getAdaptedDoc());
        }
    }

    public List<TemplateBasedDocument> getTemplateBasedDocuments() throws ClientException {
        return ((TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class)).getLinkedTemplateBasedDocuments(this.adaptedDoc);
    }

    public String getOutputFormat() {
        try {
            return (String)((Object)this.getAdaptedDoc().getPropertyValue(TEMPLATE_OUTPUT_PROP));
        }
        catch (Exception e) {
            log.error((Object)"Error while getting output format", (Throwable)e);
            return null;
        }
    }

    public void setOutputFormat(String mimetype, boolean save) {
        try {
            this.getAdaptedDoc().setPropertyValue(TEMPLATE_OUTPUT_PROP, (Serializable)((Object)mimetype));
            if (save) {
                this.doSave();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while setting output format", (Throwable)e);
        }
    }

    public boolean useAsMainContent() {
        try {
            Boolean useAsMain = (Boolean)this.getAdaptedDoc().getPropertyValue(TEMPLATE_USEASMAIN_PROP);
            if (useAsMain == null) {
                useAsMain = false;
            }
            return useAsMain;
        }
        catch (Exception e) {
            log.error((Object)"Unable to read template useAsMain prop ", (Throwable)e);
            return false;
        }
    }

    public Blob getTemplateBlob() throws ClientException {
        BlobHolder bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh != null) {
            return bh.getBlob();
        }
        return null;
    }

    public void setTemplateBlob(Blob blob, boolean save) throws Exception {
        BlobHolder bh = (BlobHolder)this.getAdaptedDoc().getAdapter(BlobHolder.class);
        if (bh != null) {
            bh.setBlob(blob);
            this.initTemplate(false);
            if (save) {
                this.doSave();
            }
        }
    }

    public String getName() {
        try {
            String name = (String)((Object)this.getAdaptedDoc().getPropertyValue(TEMPLATE_NAME_PROP));
            if (name == null) {
                name = this.getAdaptedDoc().getTitle();
            }
            return name;
        }
        catch (Exception e) {
            log.error((Object)"Error while getting output format", (Throwable)e);
            return null;
        }
    }

    public String getFileName() throws ClientException {
        Blob blob = this.getTemplateBlob();
        if (blob != null) {
            return blob.getFilename();
        }
        return null;
    }

    public String getTitle() throws ClientException {
        return this.getAdaptedDoc().getTitle();
    }

    public String getVersionLabel() {
        return this.getAdaptedDoc().getVersionLabel();
    }

    public String getId() {
        return this.getAdaptedDoc().getId();
    }

    public String getLabel() throws ClientException {
        StringBuffer sb = new StringBuffer(this.getTitle());
        if (!this.getTitle().equals(this.getFileName())) {
            sb.append(" (" + this.getFileName() + ")");
        }
        if (this.getVersionLabel() != null) {
            sb.append(" [" + this.getVersionLabel() + "]");
        }
        return sb.toString();
    }

    public String getTargetRenditionName() throws ClientException {
        try {
            String targetRendition = (String)((Object)this.getAdaptedDoc().getPropertyValue(TEMPLATE_RENDITION_PROP));
            if ("none".equals(targetRendition)) {
                return null;
            }
            return targetRendition;
        }
        catch (Exception e) {
            throw new ClientException("Unable to get target rendition", (Throwable)e);
        }
    }

    public void setTargetRenditioName(String renditionName, boolean save) throws ClientException {
        this.getAdaptedDoc().setPropertyValue(TEMPLATE_RENDITION_PROP, (Serializable)((Object)renditionName));
        if (save) {
            this.doSave();
        }
    }
}

