/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.extension;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.extension.RenditionProvider;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.runtime.api.Framework;

public class DefaultAutomationRenditionProvider
implements RenditionProvider {
    public boolean isAvailable(DocumentModel doc, RenditionDefinition def) {
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        try {
            if (bh == null || bh.getBlob() == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<Blob> render(DocumentModel doc, RenditionDefinition definition) throws RenditionException {
        String chain = definition.getOperationChain();
        if (chain == null) {
            throw new RenditionException("no operation defined");
        }
        AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
        OperationContext oc = new OperationContext();
        try {
            oc.push("blob", (Object)((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob());
            Blob blob = (Blob)as.run(oc, definition.getOperationChain());
            ArrayList<Blob> blobs = new ArrayList<Blob>();
            blobs.add(blob);
            return blobs;
        }
        catch (Exception e) {
            throw new RenditionException("Exception while running the operation chain: " + definition.getOperationChain(), e);
        }
    }
}

