/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.jxls.reader.XLSReadStatus;
import net.sf.jxls.reader.XLSReader;
import net.sf.jxls.reader.XLSSheetReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class XLSReaderImpl
implements XLSReader {
    protected final Log log = LogFactory.getLog(this.getClass());
    Map sheetReaders = new HashMap();
    XLSReadStatus readStatus = new XLSReadStatus();

    public XLSReadStatus read(InputStream inputXLS, Map beans) throws IOException, InvalidFormatException {
        this.readStatus.clear();
        Workbook workbook = WorkbookFactory.create((InputStream)inputXLS);
        for (int sheetNo = 0; sheetNo < workbook.getNumberOfSheets(); ++sheetNo) {
            this.readStatus.mergeReadStatus(this.readSheet(workbook, sheetNo, beans));
        }
        return this.readStatus;
    }

    private XLSReadStatus readSheet(Workbook workbook, int sheetNo, Map beans) {
        Sheet sheet = workbook.getSheetAt(sheetNo);
        String sheetName = workbook.getSheetName(sheetNo);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Processing sheet " + sheetName));
        }
        if (this.sheetReaders.containsKey(sheetName)) {
            XLSSheetReader sheetReader = (XLSSheetReader)this.sheetReaders.get(sheetName);
            sheetReader.setSheetName(sheetName);
            return sheetReader.read(sheet, beans);
        }
        return null;
    }

    public Map getSheetReaders() {
        return this.sheetReaders;
    }

    public void addSheetReader(String sheetName, XLSSheetReader reader) {
        this.sheetReaders.put(sheetName, reader);
    }

    public void addSheetReader(XLSSheetReader reader) {
        this.addSheetReader(reader.getSheetName(), reader);
    }

    public void setSheetReaders(Map sheetReaders) {
        this.sheetReaders = sheetReaders;
    }
}

