/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.preprocessor;

import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocument;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import org.xml.sax.SAXException;

public class ODTManifestXMLDocumentContentHandler
extends BufferedDocumentContentHandler<BufferedDocument> {
    private static final String ITEM_INFO = "___info";
    protected final IDocumentFormatter formatter;

    public ODTManifestXMLDocumentContentHandler(FieldsMetadata fieldsMetadata, IDocumentFormatter formatter) {
        this.formatter = formatter;
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if ("manifest".equals(localName)) {
            StringBuilder script = new StringBuilder();
            String startIf = this.formatter.getStartIfDirective("___ImageRegistry");
            script.append(startIf);
            this.generateScriptsForDynamicImages(script);
            script.append(this.formatter.getEndIfDirective("___ImageRegistry"));
            this.getCurrentElement().append(script.toString());
        }
        super.doEndElement(uri, localName, name);
    }

    private void generateScriptsForDynamicImages(StringBuilder script) {
        String listInfos = this.formatter.formatAsSimpleField(false, new String[]{"___ImageRegistry", "ImageProviderInfos"});
        String itemListInfos = this.formatter.formatAsSimpleField(false, new String[]{ITEM_INFO});
        String startLoop = this.formatter.getStartLoopDirective(itemListInfos, listInfos);
        script.append(startLoop);
        String mediaType = "image/" + this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageType"});
        String fullPath = this.formatter.formatAsSimpleField(true, new String[]{ITEM_INFO, "ImageFullPath"});
        this.generateManifestFileEntry(script, mediaType, fullPath);
        script.append(this.formatter.getEndLoopDirective(itemListInfos));
    }

    protected void generateManifestFileEntry(StringBuilder script, String mediaType, String fullPath) {
        script.append("<manifest:file-entry manifest:media-type=\"");
        script.append(mediaType);
        script.append("\" manifest:full-path=\"");
        script.append(fullPath);
        script.append("\" />");
    }
}

