/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.introspection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.ArrayIterator;
import org.apache.commons.jexl2.internal.EnumerationIterator;
import org.apache.commons.jexl2.internal.Introspector;
import org.apache.commons.jexl2.internal.introspection.MethodKey;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.JexlPropertyGet;
import org.apache.commons.jexl2.introspection.JexlPropertySet;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UberspectImpl
extends Introspector
implements Uberspect {
    public static final Object TRY_FAILED = AbstractExecutor.TRY_FAILED;

    public UberspectImpl(Log runtimeLogger) {
        super(runtimeLogger);
    }

    @Override
    public Iterator<?> getIterator(Object obj, JexlInfo info) {
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Iterable) {
            return ((Iterable)obj).iterator();
        }
        try {
            AbstractExecutor.Method it = this.getMethodExecutor(obj, "iterator", null);
            if (it != null && Iterator.class.isAssignableFrom(it.getReturnType())) {
                return (Iterator)it.execute(obj, null);
            }
        }
        catch (Exception xany) {
            throw new JexlException(info, "unable to generate iterator()", (Throwable)xany);
        }
        return null;
    }

    public Field getField(Object obj, String name, JexlInfo info) {
        Class<?> clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        return this.getField(clazz, name);
    }

    @Override
    public Constructor<?> getConstructor(Object ctorHandle, Object[] args, JexlInfo info) {
        return this.getConstructor(ctorHandle, args);
    }

    @Override
    public JexlMethod getMethod(Object obj, String method, Object[] args, JexlInfo info) {
        return this.getMethodExecutor(obj, method, args);
    }

    @Override
    public JexlPropertyGet getPropertyGet(Object obj, Object identifier, JexlInfo info) {
        Field field;
        AbstractExecutor.Get get = this.getGetExecutor(obj, identifier);
        if (get == null && obj != null && identifier != null && (field = this.getField(obj, identifier.toString(), info)) != null) {
            return new FieldPropertyGet(field);
        }
        return get;
    }

    @Override
    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg, JexlInfo info) {
        Field field;
        AbstractExecutor.Set set = this.getSetExecutor(obj, identifier, arg);
        if (set == null && obj != null && identifier != null && (field = this.getField(obj, identifier.toString(), info)) != null && !Modifier.isFinal(field.getModifiers()) && (arg == null || MethodKey.isInvocationConvertible(field.getType(), arg.getClass(), false))) {
            return new FieldPropertySet(field);
        }
        return set;
    }

    public static final class FieldPropertySet
    implements JexlPropertySet {
        private final Field field;

        public FieldPropertySet(Field theField) {
            this.field = theField;
        }

        public Object invoke(Object obj, Object arg) throws Exception {
            this.field.set(obj, arg);
            return arg;
        }

        public Object tryInvoke(Object obj, Object key, Object value) {
            if (obj.getClass().equals(this.field.getDeclaringClass()) && key.equals(this.field.getName()) && (value == null || MethodKey.isInvocationConvertible(this.field.getType(), value.getClass(), false))) {
                try {
                    this.field.set(obj, value);
                    return value;
                }
                catch (IllegalAccessException xill) {
                    return TRY_FAILED;
                }
            }
            return TRY_FAILED;
        }

        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        public boolean isCacheable() {
            return true;
        }
    }

    public static final class FieldPropertyGet
    implements JexlPropertyGet {
        private final Field field;

        public FieldPropertyGet(Field theField) {
            this.field = theField;
        }

        public Object invoke(Object obj) throws Exception {
            return this.field.get(obj);
        }

        public Object tryInvoke(Object obj, Object key) {
            if (obj.getClass().equals(this.field.getDeclaringClass()) && key.equals(this.field.getName())) {
                try {
                    return this.field.get(obj);
                }
                catch (IllegalAccessException xill) {
                    return TRY_FAILED;
                }
            }
            return TRY_FAILED;
        }

        public boolean tryFailed(Object rval) {
            return rval == TRY_FAILED;
        }

        public boolean isCacheable() {
            return true;
        }
    }
}

