/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateMappingFetcher
extends UnrestrictedSessionRunner {
    protected static String repoName;
    protected static final Log log;
    protected Map<String, List<String>> mapping = new HashMap<String, List<String>>();

    protected static String getRepoName() {
        if (repoName == null) {
            RepositoryManager rm = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
            repoName = rm.getDefaultRepositoryName();
        }
        return repoName;
    }

    protected TemplateMappingFetcher() {
        super(TemplateMappingFetcher.getRepoName());
    }

    public void run() throws ClientException {
        StringBuffer sb = new StringBuffer("select * from Document where ");
        sb.append("tmpl:forcedTypes");
        sb.append(" <> ''");
        sb.append(" order by dc:modified desc");
        DocumentModelList docs = this.session.query(sb.toString());
        for (DocumentModel doc : docs) {
            TemplateSourceDocument tmpl = (TemplateSourceDocument)doc.getAdapter(TemplateSourceDocument.class);
            if (tmpl == null) continue;
            for (String type : tmpl.getForcedTypes()) {
                if (this.mapping.containsKey(type)) {
                    this.mapping.get(type).add(doc.getId());
                    continue;
                }
                ArrayList<String> templates = new ArrayList<String>();
                templates.add(doc.getId());
                this.mapping.put(type, templates);
            }
        }
    }

    public Map<String, List<String>> getMapping() {
        return this.mapping;
    }

    static {
        log = LogFactory.getLog(TemplateMappingFetcher.class);
    }
}

