/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.domain;

import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import java.util.List;

public class ResourceHelper {
    public static Resource findFieldsMetadataFromTemplate(Resource template) {
        Resource metaInf = ResourceHelper.findMetaInfFromTemplate(template);
        if (metaInf == null) {
            return null;
        }
        return ResourceHelper.findFieldsMetadataFromMetaInf(metaInf);
    }

    public static Resource findMetaInfFromTemplate(Resource template) {
        List<Resource> resources = template.getChildren();
        for (Resource resource : resources) {
            if (!"META-INF".equals(resource.getName())) continue;
            return resource;
        }
        return null;
    }

    public static Resource findFieldsMetadataFromMetaInf(Resource metaInf) {
        List<Resource> resources = metaInf.getChildren();
        for (Resource resource : resources) {
            if (!ResourceHelper.isFieldsMetadata(resource)) continue;
            return resource;
        }
        return null;
    }

    public static boolean isFieldsMetadata(Resource resource) {
        return ResourceHelper.isFieldsMetadata(resource.getName());
    }

    public static boolean isFieldsMetadata(String name) {
        return name != null && name.endsWith(".fields.xml");
    }

    public static String getResourcePath(Resource resource) {
        StringBuilder path = new StringBuilder();
        ResourceHelper.computePath(resource, path);
        return path.toString();
    }

    private static void computePath(Resource resource, StringBuilder path) {
        ResourceHelper.insertPath(resource, path);
        for (Resource parent = resource.getParent(); parent != null; parent = parent.getParent()) {
            ResourceHelper.insertPath(parent, path);
        }
    }

    private static void insertPath(Resource resource, StringBuilder path) {
        if (path.length() > 0) {
            path.insert(0, '/');
        }
        path.insert(0, resource.getName());
    }
}

