/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.web;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.rendition.TemplateBasedRenditionProvider;

public class BaseTemplateAction
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Log log = LogFactory.getLog(BaseTemplateAction.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected Map<String, String> messages;
    protected List<TemplateInput> templateEditableInputs;
    protected TemplateInput newInput;

    public boolean canAddTemplateInputs() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        return template != null;
    }

    public boolean canUpdateTemplateInputs(String templateName) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template != null) {
            return true;
        }
        TemplateBasedDocument templateBased = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        if (templateBased != null) {
            return templateBased.hasEditableParams(templateName);
        }
        return false;
    }

    public boolean canResetParameters() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (!this.documentManager.hasPermission(currentDocument.getRef(), "Write")) {
            return false;
        }
        TemplateBasedDocument templateBased = (TemplateBasedDocument)currentDocument.getAdapter(TemplateBasedDocument.class);
        return templateBased != null;
    }

    public TemplateSourceDocument getCurrentDocumentAsTemplateSourceDocument() {
        return (TemplateSourceDocument)this.navigationContext.getCurrentDocument().getAdapter(TemplateSourceDocument.class);
    }

    public DocumentModel resolveTemplateById(String uuid) {
        try {
            return this.documentManager.getDocument((DocumentRef)new IdRef(uuid));
        }
        catch (DocumentNotFoundException e) {
            return null;
        }
    }

    public List<RenditionDefinition> getRenditions() {
        RenditionService rs = (RenditionService)Framework.getLocalService(RenditionService.class);
        return rs.getDeclaredRenditionDefinitionsForProviderType(TemplateBasedRenditionProvider.class.getSimpleName());
    }

    public List<TemplateSourceDocument> getAvailableOfficeTemplates(String targetType) {
        TemplateProcessorService tps = (TemplateProcessorService)Framework.getLocalService(TemplateProcessorService.class);
        return tps.getAvailableOfficeTemplates(this.documentManager, targetType);
    }

    public String addTemplateInput() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template != null) {
            if (template.hasInput(this.newInput.getName())) {
                this.facesMessages.add(StatusMessage.Severity.WARN, this.messages.get("label.template.parameter.already.exist"), new Object[]{this.newInput.getName()});
                return null;
            }
        } else {
            return null;
        }
        template.addInput(this.newInput);
        this.newInput = null;
        this.templateEditableInputs = null;
        return this.navigationContext.navigateToDocument(currentDocument);
    }
}

