/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal;

import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.jexl2.internal.AbstractExecutor;
import org.apache.commons.jexl2.internal.Introspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapGetExecutor
extends AbstractExecutor.Get {
    private static final Method MAP_GET = MapGetExecutor.initMarker(Map.class, "get", Object.class);
    private final Object property;

    public MapGetExecutor(Introspector is, Class<?> clazz, Object key) {
        super(clazz, MapGetExecutor.discover(clazz));
        this.property = key;
    }

    @Override
    public Object getTargetProperty() {
        return this.property;
    }

    @Override
    public Object execute(Object obj) {
        Map map = (Map)obj;
        return map.get(this.property);
    }

    @Override
    public Object tryExecute(Object obj, Object key) {
        if (obj != null && this.method != null && this.objectClass.equals(obj.getClass()) && (key == null || this.property.getClass().equals(key.getClass()))) {
            Map map = (Map)obj;
            return map.get(key);
        }
        return TRY_FAILED;
    }

    static Method discover(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz) ? MAP_GET : null;
    }
}

