/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.reader;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import net.sf.jxls.reader.ReaderConfig;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.util.CellReference;

public class BeanCellMapping {
    protected final Log log = LogFactory.getLog(this.getClass());
    int row;
    short col;
    String propertyName;
    String beanKey;
    String cell;
    String type = null;
    boolean nullAllowed = false;
    static /* synthetic */ Class class$java$lang$Object;

    public BeanCellMapping(int rowNum, short cellNum, String fullPropertyName) {
        this.row = rowNum;
        this.col = cellNum;
        this.beanKey = this.extractBeanName(fullPropertyName);
        this.propertyName = this.extractPropertyName(fullPropertyName);
    }

    public BeanCellMapping(String cell, String fullPropertyName) {
        this.setCell(cell);
        this.beanKey = this.extractBeanName(fullPropertyName);
        this.propertyName = this.extractPropertyName(fullPropertyName);
    }

    public BeanCellMapping(int rowNum, short cellNum, String beanKey, String propertyName) {
        this.row = rowNum;
        this.col = cellNum;
        this.beanKey = beanKey;
        this.propertyName = propertyName;
    }

    public BeanCellMapping(String cell, String beanKey, String propertyName) {
        this.setCell(cell);
        this.beanKey = beanKey;
        this.propertyName = propertyName;
    }

    public BeanCellMapping() {
    }

    public String getBeanKey() {
        return this.beanKey;
    }

    public void setBeanKey(String beanKey) {
        this.beanKey = beanKey;
    }

    public String getFullPropertyName() {
        return this.beanKey + "." + this.propertyName;
    }

    public void setFullPropertyName(String fullPropertyName) {
        this.beanKey = this.extractBeanName(fullPropertyName);
        this.propertyName = this.extractPropertyName(fullPropertyName);
    }

    private String extractPropertyName(String fullPropertyName) {
        if (fullPropertyName == null) {
            return null;
        }
        int dotIndex = fullPropertyName.indexOf(46);
        if (dotIndex < 0) {
            throw new IllegalArgumentException("Full property name must contain period. Can't extract bean property name from " + fullPropertyName);
        }
        return fullPropertyName.substring(dotIndex + 1);
    }

    private String extractBeanName(String fullPropertyName) {
        if (fullPropertyName == null) {
            return null;
        }
        int dotIndex = fullPropertyName.indexOf(46);
        if (dotIndex < 0) {
            throw new IllegalArgumentException("Full property name must contain period. Can't extract bean name from " + fullPropertyName);
        }
        return fullPropertyName.substring(0, dotIndex);
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int row) {
        this.row = row;
    }

    public short getCol() {
        return this.col;
    }

    public void setCol(short col) {
        this.col = col;
    }

    public String getCell() {
        return this.cell;
    }

    public void setCell(String cell) {
        this.cell = cell;
        CellReference cellRef = new CellReference(cell);
        this.row = cellRef.getRow();
        this.col = cellRef.getCol();
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isNullAllowed() {
        return this.nullAllowed;
    }

    public void setNullAllowed(boolean nullAllowed) {
        this.nullAllowed = nullAllowed;
    }

    public void populateBean(String dataString, Map beans) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        if (beans.containsKey(this.beanKey)) {
            Object bean = beans.get(this.beanKey);
            Class dataType = this.getPropertyType(beans);
            Object value = null;
            if (!this.nullAllowed || dataString != null) {
                value = ConvertUtils.convert((String)dataString, (Class)dataType);
            }
            PropertyUtils.setProperty(bean, (String)this.propertyName, (Object)value);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Can't find bean under the key=" + this.beanKey));
        }
    }

    public Class getPropertyType(Map beans) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (beans.containsKey(this.beanKey)) {
            Object bean = beans.get(this.beanKey);
            if (this.type == null) {
                return PropertyUtils.getPropertyType(bean, (String)this.propertyName);
            }
            return Class.forName(this.type);
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = BeanCellMapping.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public String getCellName() {
        CellReference cellRef = new CellReference(this.row, (int)this.col, false, false);
        return cellRef.formatAsString();
    }

    public String toString() {
        return this.beanKey + ":" + this.propertyName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ReaderConfig.getInstance();
    }
}

