/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.service;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.template.api.descriptor.TemplateProcessorDescriptor;

public class TemplateProcessorRegistry
extends ContributionFragmentRegistry<TemplateProcessorDescriptor> {
    protected Map<String, TemplateProcessorDescriptor> processors = new HashMap<String, TemplateProcessorDescriptor>();

    public TemplateProcessorDescriptor clone(TemplateProcessorDescriptor tpd) {
        return tpd.clone();
    }

    public TemplateProcessorDescriptor getProcessorByName(String name) {
        return this.processors.get(name);
    }

    public Collection<TemplateProcessorDescriptor> getRegistredProcessors() {
        return this.processors.values();
    }

    public void contributionRemoved(String id, TemplateProcessorDescriptor tpd) {
        this.processors.remove(id);
    }

    public void contributionUpdated(String id, TemplateProcessorDescriptor tpd, TemplateProcessorDescriptor newTpd) {
        if (tpd == null || !tpd.isEnabled()) {
            this.processors.remove(id);
        } else if (tpd.init()) {
            this.processors.put(id, tpd);
        } else {
            throw new NuxeoException("Unable to register processor");
        }
    }

    public String getContributionId(TemplateProcessorDescriptor tpd) {
        return tpd.getName();
    }

    public void merge(TemplateProcessorDescriptor srcTpd, TemplateProcessorDescriptor descTpd) {
        descTpd.merge(srcTpd);
    }
}

