/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.InitialNoteInfoMap;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.NoteInfo;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedAttribute;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNoteBufferedRegion
extends BufferedElement {
    private final DocXBufferedDocumentContentHandler handler;
    private BufferedAttribute idAttribute;
    private String type;
    private boolean containsField;

    public AbstractNoteBufferedRegion(DocXBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public void process() {
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (formatter == null) {
            return;
        }
        if (this.handler.hasSharedContext()) {
            InitialNoteInfoMap infos;
            String id = this.idAttribute.getValue();
            if (!StringUtils.isEmpty((String)this.type)) {
                return;
            }
            String content = "";
            if (this.isContainsField()) {
                content = super.getInnerText();
                super.setInnerText(formatter.formatAsSimpleField(true, true, new String[]{"___NoEscapeNoteInfo", "content"}));
            }
            if ((infos = this.getInitialNoteInfoMap(this.handler.getSharedContext())) == null) {
                infos = new InitialNoteInfoMap();
                this.putInitialNoteInfoMap(this.handler.getSharedContext(), infos);
            }
            NoteInfo info = new NoteInfo(id, content);
            infos.put(id, info);
            String newId = formatter.formatAsSimpleField(true, new String[]{"___NoEscapeNoteInfo", "id"});
            this.idAttribute.setValue(newId);
            String listName = formatter.getFunctionDirective(false, this.getNoteRegistryKey(), "getNotes", new String[]{"'" + id + "'"});
            String before = formatter.getStartLoopDirective("___NoEscapeNoteInfo", listName);
            this.setContentBeforeStartTagElement(before);
            String after = formatter.getEndLoopDirective("");
            this.setContentAfterEndTagElement(after);
        }
    }

    protected abstract InitialNoteInfoMap getInitialNoteInfoMap(Map<String, Object> var1);

    protected abstract void putInitialNoteInfoMap(Map<String, Object> var1, InitialNoteInfoMap var2);

    public void setId(String name, String value) {
        if (this.idAttribute == null) {
            this.idAttribute = super.setAttribute(name, value);
        }
        this.idAttribute.setValue(value);
    }

    public void setContainsField(boolean containsField) {
        this.containsField = containsField;
    }

    public boolean isContainsField() {
        return this.containsField;
    }

    public void setType(String type) {
        this.type = type;
    }

    protected abstract String getNoteRegistryKey();
}

