/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.jsf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.webapp.contentbrowser.DocumentActions;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateInput;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;
import org.nuxeo.template.api.descriptor.OutputFormatDescriptor;
import org.nuxeo.template.api.descriptor.TemplateProcessorDescriptor;
import org.nuxeo.template.jsf.BaseTemplateAction;

@Name(value="templateActions")
@Scope(value=ScopeType.CONVERSATION)
public class TemplatesActionBean
extends BaseTemplateAction {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    protected transient DocumentActions documentActions;
    @In(create=true)
    protected transient TypeManager typeManager;
    protected List<TemplateInput> templateInputs;
    protected boolean showParamEditor = false;
    protected boolean showUsageListing = false;
    protected boolean showVersions = false;
    protected boolean checkedInVersion = false;

    public String createTemplate() {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        TemplateSourceDocument sourceTemplate = (TemplateSourceDocument)changeableDocument.getAdapter(TemplateSourceDocument.class);
        if (sourceTemplate != null && sourceTemplate.getTemplateBlob() != null) {
            try {
                sourceTemplate.initTemplate(false);
                if (sourceTemplate.hasEditableParams()) {
                    this.templateInputs = sourceTemplate.getParams();
                    return "editTemplateRelatedData";
                }
            }
            catch (PropertyException e) {
                log.error((Object)"Error during parameter automatic initialization", (Throwable)e);
            }
        }
        return this.documentActions.saveDocument(changeableDocument);
    }

    public List<TemplateInput> getTemplateInputs() {
        return this.templateInputs;
    }

    public void setTemplateInputs(List<TemplateInput> templateInputs) {
        this.templateInputs = templateInputs;
    }

    public String saveDocument() {
        DocumentModel changeableDocument = this.navigationContext.getChangeableDocument();
        for (TemplateInput ti : this.templateInputs) {
            log.info((Object)ti.toString());
        }
        TemplateSourceDocument source = (TemplateSourceDocument)changeableDocument.getAdapter(TemplateSourceDocument.class);
        if (source != null) {
            source.saveParams(this.templateInputs, false);
        }
        return this.documentActions.saveDocument(changeableDocument);
    }

    @Observer(value={"documentSelectionChanged", "changeableDocumentCreated", "documentChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.templateInputs = null;
        this.templateEditableInputs = null;
        this.showParamEditor = false;
    }

    public List<TemplateInput> getTemplateEditableInputs() {
        DocumentModel currentDocument;
        TemplateSourceDocument template;
        if (this.templateEditableInputs == null && (template = (TemplateSourceDocument)(currentDocument = this.navigationContext.getCurrentDocument()).getAdapter(TemplateSourceDocument.class)) != null) {
            this.templateEditableInputs = template.getParams();
        }
        return this.templateEditableInputs;
    }

    public void setTemplateEditableInputs(List<TemplateInput> templateEditableInputs) {
        this.templateEditableInputs = templateEditableInputs;
    }

    public String saveTemplateInputs() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template != null) {
            currentDocument = template.saveParams(this.templateEditableInputs, true);
        }
        this.navigationContext.invalidateCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDocument);
    }

    public void cancelTemplateInputsEdit() {
        this.reset();
    }

    public TemplateInput getNewInput() {
        if (this.newInput == null) {
            this.newInput = new TemplateInput("newField");
        }
        return this.newInput;
    }

    public void setNewInput(TemplateInput newInput) {
        this.newInput = newInput;
    }

    @Override
    public String addTemplateInput() {
        this.showParamEditor = true;
        return super.addTemplateInput();
    }

    public String removeTemplateInput(String name) {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        this.showParamEditor = true;
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template != null) {
            ListIterator it = this.templateEditableInputs.listIterator();
            while (it.hasNext()) {
                TemplateInput input = (TemplateInput)it.next();
                if (!input.getName().equals(name)) continue;
                it.remove();
                break;
            }
            currentDocument = template.saveParams(this.templateEditableInputs, true);
            this.newInput = null;
            this.templateEditableInputs = null;
            this.navigationContext.invalidateCurrentDocument();
            return this.navigationContext.navigateToDocument(currentDocument);
        }
        return null;
    }

    public Collection<Type> getAllTypes() {
        return this.typeManager.getTypes();
    }

    public Collection<Type> getForcableTypes() {
        Collection types = this.typeManager.getTypes();
        Iterator it = types.iterator();
        while (it.hasNext()) {
            Type type = (Type)it.next();
            if (!type.getId().equals("TemplateBasedFile")) continue;
            it.remove();
            break;
        }
        return types;
    }

    public Collection<TemplateProcessorDescriptor> getRegistredTemplateProcessors() {
        return ((TemplateProcessorService)Framework.getService(TemplateProcessorService.class)).getRegisteredTemplateProcessors();
    }

    public Collection<OutputFormatDescriptor> getOutputFormatDescriptors() {
        return ((TemplateProcessorService)Framework.getService(TemplateProcessorService.class)).getOutputFormats();
    }

    public List<String> getTemplateAndVersionsUUIDs() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        TemplateSourceDocument template = (TemplateSourceDocument)currentDocument.getAdapter(TemplateSourceDocument.class);
        if (template != null) {
            ArrayList<String> uuids = new ArrayList<String>();
            uuids.add("\"" + currentDocument.getId() + "\"");
            if (this.showVersions) {
                for (DocumentModel version : this.documentManager.getVersions(currentDocument.getRef())) {
                    uuids.add("\"" + version.getId() + "\"");
                }
            }
            return uuids;
        }
        return new ArrayList<String>();
    }

    public boolean isShowParamEditor() {
        return this.showParamEditor;
    }

    public boolean isShowUsageListing() {
        return this.showUsageListing;
    }

    public void setShowUsageListing(boolean showUsageListing) {
        this.showUsageListing = showUsageListing;
    }

    public boolean isShowVersions() {
        return this.showVersions;
    }

    public void setShowVersions(boolean showVersions) {
        this.showVersions = showVersions;
    }

    public boolean isCheckedInVersion() {
        return this.checkedInVersion;
    }

    public void setCheckedInVersion(boolean checkedInVersion) {
        this.checkedInVersion = checkedInVersion;
    }
}

