/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.remoting.resources.domain;

import fr.opensagres.xdocreport.remoting.resources.domain.Resource;
import fr.opensagres.xdocreport.remoting.resources.domain.ResourceType;

public class ResourceFactory {
    public static final String META_INF = "META-INF";
    public static final String FIELDS_XML = ".fields.xml";

    public static Resource createResource(String name, ResourceType type, Resource parent) {
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(type);
        if (parent != null) {
            parent.getChildren().add(resource);
        }
        return resource;
    }

    public static Resource createCategory(String name, Resource parent) {
        return ResourceFactory.createResource(name, ResourceType.CATEGORY, parent);
    }

    public static Resource createDocument(String name, Resource parent) {
        return ResourceFactory.createResource(name, ResourceType.DOCUMENT, parent);
    }

    public static Resource createTemplate(String name, Resource parent) {
        String templateName = name;
        int index = name.lastIndexOf(46);
        if (index != -1) {
            templateName = templateName.substring(0, index);
        }
        Resource template = ResourceFactory.createResource(templateName, ResourceType.TEMPLATE, parent);
        ResourceFactory.createDocument(name, template);
        Resource metaInf = ResourceFactory.createCategory(META_INF, template);
        StringBuilder fieldsMetadata = new StringBuilder(templateName);
        fieldsMetadata.append(FIELDS_XML);
        ResourceFactory.createDocument(fieldsMetadata.toString(), metaInf);
        return template;
    }
}

