/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocument;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.IBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.PrefixMapping;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferedDocumentContentHandler<Document extends BufferedDocument>
extends DefaultHandler {
    private static final String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    public static final String CDATA_TYPE = "CDATA";
    private final List<PrefixMapping> prefixs;
    protected final Document bufferedDocument;
    private final StringBuilder currentCharacters = new StringBuilder();
    private boolean startingElement = false;
    private int elementIndex = 0;

    public BufferedDocumentContentHandler() {
        this.bufferedDocument = this.createDocument();
        this.prefixs = new ArrayList<PrefixMapping>();
    }

    protected Document createDocument() {
        return (Document)new BufferedDocument();
    }

    public Document getBufferedDocument() {
        return this.bufferedDocument;
    }

    @Override
    public void startDocument() throws SAXException {
        ((BufferedElement)this.bufferedDocument).append(XML_DECLARATION);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        String xmlnsPrefix = StringUtils.isEmpty((String)prefix) ? "xmlns" : "xmlns:" + prefix;
        this.prefixs.add(new PrefixMapping(xmlnsPrefix, uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.startingElement) {
            this.getCurrentElement().append(">");
        }
        if (this.currentCharacters.length() > 0) {
            this.flushCharacters(this.currentCharacters.toString());
            this.resetCharacters();
        }
        BufferedElement element = null;
        try {
            element = ((BufferedDocument)this.bufferedDocument).onStartStartElement(uri, localName, name, attributes);
            this.startingElement = this.doStartElement(uri, localName, name, element.getAttributes());
            ++this.elementIndex;
        }
        finally {
            ((BufferedDocument)this.bufferedDocument).onEndStartElement(element, uri, localName, name, attributes);
        }
    }

    public BufferedElement getCurrentElement() {
        return ((BufferedDocument)this.bufferedDocument).getCurrentElement();
    }

    protected BufferedElement findParentElementInfo(String name) {
        return this.findParentElementInfo(this.getCurrentElement(), name);
    }

    protected BufferedElement findParentElementInfo(BufferedElement elementInfo, String name) {
        if (elementInfo == null) {
            return null;
        }
        if (elementInfo.match(name)) {
            return elementInfo;
        }
        return this.findParentElementInfo(elementInfo.getParent(), name);
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        BufferedElement currentRegion = this.getCurrentElement();
        currentRegion.append("<");
        currentRegion.append(name);
        String attrName = null;
        String attrValue = null;
        if (this.prefixs.size() > 0) {
            int length = attributes.getLength();
            HashMap<String, PrefixMapping> addedPrefixs = length > 0 ? new HashMap<String, PrefixMapping>() : null;
            for (PrefixMapping prefix : this.prefixs) {
                attrName = prefix.getPrefix();
                attrValue = prefix.getURI();
                currentRegion.append(' ');
                currentRegion.append(attrName);
                currentRegion.append("=\"");
                currentRegion.append(attrValue);
                currentRegion.append("\"");
                if (addedPrefixs == null) continue;
                addedPrefixs.put(prefix.getPrefix(), prefix);
            }
            if (length > 0) {
                PrefixMapping prefix = null;
                for (int i = 0; i < length; ++i) {
                    attrName = attributes.getQName(i);
                    if (addedPrefixs != null) {
                        prefix = (PrefixMapping)addedPrefixs.get(attrName);
                    }
                    if (prefix != null) continue;
                    currentRegion.append(' ');
                    attrValue = attributes.getValue(i);
                    currentRegion.append(attrName);
                    currentRegion.append("=\"");
                    this.printEscaped(attrValue, currentRegion);
                    currentRegion.append("\"");
                }
            }
            if (addedPrefixs != null) {
                addedPrefixs.clear();
                addedPrefixs = null;
            }
            this.prefixs.clear();
        } else {
            int length = attributes.getLength();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    currentRegion.append(' ');
                    attrName = attributes.getQName(i);
                    attrValue = attributes.getValue(i);
                    currentRegion.append(attrName);
                    currentRegion.append("=\"");
                    this.printEscaped(attrValue, currentRegion);
                    currentRegion.append("\"");
                }
            }
        }
        currentRegion.registerDynamicAttributes();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void endElement(String uri, String localName, String name) throws SAXException {
        --this.elementIndex;
        if (this.currentCharacters.length() > 0) {
            this.flushCharacters(this.currentCharacters.toString());
            this.resetCharacters();
        }
        try {
            ((BufferedDocument)this.bufferedDocument).onStartEndElement(uri, localName, name);
            if (this.startingElement) {
                BufferedElement currentRegion = this.getCurrentElement();
                currentRegion.append("/>");
                this.startingElement = false;
            } else {
                this.doEndElement(uri, localName, name);
            }
        }
        finally {
            ((BufferedDocument)this.bufferedDocument).onEndEndElement(uri, localName, name);
        }
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        BufferedElement currentRegion = this.getCurrentElement();
        currentRegion.append("</");
        currentRegion.append(name);
        currentRegion.append(">");
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.startingElement) {
            BufferedElement currentRegion = this.getCurrentElement();
            currentRegion.append(">");
        }
        this.startingElement = false;
        for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            if (this.mustEncodeCharachers()) {
                if (c == '<') {
                    this.currentCharacters.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.currentCharacters.append("&gt;");
                    continue;
                }
                if (c == '\'') {
                    this.currentCharacters.append("&apos;");
                    continue;
                }
                if (c == '&') {
                    this.currentCharacters.append("&amp;");
                    continue;
                }
                this.currentCharacters.append(c);
                continue;
            }
            this.currentCharacters.append(c);
        }
    }

    protected boolean mustEncodeCharachers() {
        return true;
    }

    protected void flushCharacters(String characters) {
        BufferedElement currentRegion = this.getCurrentElement();
        currentRegion.append(characters);
    }

    protected void resetCharacters() {
        this.currentCharacters.setLength(0);
    }

    public static AttributesImpl toAttributesImpl(Attributes attributes) {
        if (attributes instanceof AttributesImpl) {
            return (AttributesImpl)attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        return attributesImpl;
    }

    protected void printEscaped(String source, IBufferedRegion region) {
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '\n' || ch == '\r' || ch == '\t') {
                this.printHex(ch, region);
                continue;
            }
            if (ch == '<') {
                region.append("&lt;");
                continue;
            }
            if (ch == '&') {
                region.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                region.append("&quot;");
                continue;
            }
            region.append(ch);
        }
    }

    final void printHex(int ch, IBufferedRegion region) {
        region.append("&#x");
        region.append(Integer.toHexString(ch));
        region.append(';');
    }

    public int getElementIndex() {
        return this.elementIndex;
    }
}

