/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jxls.controller.SheetTransformationController;
import net.sf.jxls.controller.SheetTransformationControllerImpl;
import net.sf.jxls.controller.WorkbookTransformationController;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.formula.ListRange;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.parser.CellParser;
import net.sf.jxls.processor.RowProcessor;
import net.sf.jxls.tag.Block;
import net.sf.jxls.transformation.ResultTransformation;
import net.sf.jxls.transformer.BaseRowTransformer;
import net.sf.jxls.transformer.ChainTransformer;
import net.sf.jxls.transformer.CollectionRowTransformer;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import net.sf.jxls.transformer.RowTransformer;
import net.sf.jxls.transformer.Sheet;
import net.sf.jxls.transformer.SimpleRowTransformer;
import net.sf.jxls.transformer.TagRowTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SheetTransformer {
    protected static final Log log = LogFactory.getLog(SheetTransformer.class);
    private Set groupedCollections = new HashSet();
    private Set fixedSizeCollections = new HashSet();
    private Configuration configuration;
    private List rowProcessors = new ArrayList();
    private List ownTransformers = new ArrayList();
    private List cellProcessors = new ArrayList();

    public SheetTransformer(Set fixedSizeCollections, Set groupedCollections, List rowProcessors, List cellProcessors, Configuration configuration) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.groupedCollections = groupedCollections;
        this.rowProcessors = rowProcessors;
        this.cellProcessors = cellProcessors;
        this.configuration = configuration;
    }

    public SheetTransformer(Set fixedSizeCollections, Set groupedCollections, List rowProcessors, List cellProcessors) {
        this.fixedSizeCollections = fixedSizeCollections;
        this.groupedCollections = groupedCollections;
        this.rowProcessors = rowProcessors;
        this.cellProcessors = cellProcessors;
        this.configuration = new Configuration();
    }

    public void setGroupedCollections(Set groupedCollections) {
        this.groupedCollections = groupedCollections;
    }

    void transformSheet(WorkbookTransformationController workbookTransformationController, Sheet sheet, Map beans) throws ParsePropertyException {
        log.debug((Object)("Processing sheet: " + sheet.getSheetName()));
        this.exposePOIBeans(sheet, beans);
        if (!beans.isEmpty()) {
            SheetTransformationControllerImpl stc = new SheetTransformationControllerImpl(sheet);
            workbookTransformationController.addSheetTransformationController(stc);
            for (int i = sheet.getPoiSheet().getFirstRowNum(); i <= sheet.getPoiSheet().getLastRowNum(); ++i) {
                List rowTransformers;
                org.apache.poi.ss.usermodel.Row hssfRow = sheet.getPoiSheet().getRow(i);
                if (hssfRow == null || (rowTransformers = this.parseRow(sheet, hssfRow, beans)).isEmpty()) continue;
                ResultTransformation processResult = new ResultTransformation();
                RowTransformer rowTransformer = (RowTransformer)rowTransformers.get(0);
                if (rowTransformer != null) {
                    Row row = rowTransformer.getRow();
                    this.applyRowProcessors(sheet, row);
                    processResult = rowTransformer.transform(stc, this, beans, null);
                    this.ownTransformers.add(rowTransformer);
                    i = !processResult.isTagProcessResult() ? (i += processResult.getNextRowShift()) : (processResult.getLastProcessedRow() >= 0 ? processResult.getLastProcessedRow() : --i);
                }
                int c2 = rowTransformers.size();
                for (int j = 1; j < c2; ++j) {
                    rowTransformer = (RowTransformer)rowTransformers.get(j);
                    if (rowTransformer == null) continue;
                    Block transformationBlock = rowTransformer.getTransformationBlock();
                    transformationBlock = processResult.transformBlock(transformationBlock);
                    rowTransformer.setTransformationBlock(transformationBlock);
                    ResultTransformation newTransformation = rowTransformer.transform(stc, this, beans, processResult);
                    processResult.add(newTransformation);
                    this.ownTransformers.add(rowTransformer);
                }
            }
            this.groupRows(sheet);
        }
    }

    private void exposePOIBeans(Sheet sheet, Map beans) {
        beans.put(this.configuration.getSheetKeyName(), sheet.getPoiSheet());
    }

    public ResultTransformation processRows(SheetTransformationController stc, Sheet sheet, int startRow, int endRow, Map beans, Row parentRow) throws ParsePropertyException {
        int origEndRow = endRow;
        int nextRowShiftNumber = 0;
        boolean hasTagProcessing = false;
        int lastProcessedRow = -1;
        for (int i = startRow; i <= endRow; ++i) {
            org.apache.poi.ss.usermodel.Row hssfRow = sheet.getPoiSheet().getRow(i);
            if (hssfRow == null) continue;
            ResultTransformation processResult = this.processRow(stc, sheet, hssfRow, beans, parentRow);
            if (!processResult.isTagProcessResult()) {
                int shiftNumber = processResult.getNextRowShift();
                nextRowShiftNumber += shiftNumber;
                endRow += processResult.getLastRowShift();
                lastProcessedRow = i += shiftNumber;
                continue;
            }
            hasTagProcessing = true;
            if (processResult.getLastProcessedRow() >= 0) {
                lastProcessedRow = i = processResult.getLastProcessedRow();
            } else {
                --i;
            }
            endRow += processResult.getLastRowShift();
        }
        ResultTransformation r = new ResultTransformation(nextRowShiftNumber, endRow - origEndRow);
        r.setTagProcessResult(hasTagProcessing);
        r.setLastProcessedRow(lastProcessedRow);
        return r;
    }

    ResultTransformation processRow(SheetTransformationController stc, Sheet sheet, org.apache.poi.ss.usermodel.Row hssfRow, Map beans, Row parentRow) {
        return this.processRow(stc, sheet, hssfRow, hssfRow.getFirstCellNum(), hssfRow.getLastCellNum(), beans, parentRow);
    }

    public ResultTransformation processRow(SheetTransformationController stc, Sheet sheet, org.apache.poi.ss.usermodel.Row hssfRow, int startCell, int endCell, Map beans, Row parentRow) {
        List transformers = this.parseCells(sheet, hssfRow, startCell, endCell, beans);
        ChainTransformer chainTransformer = new ChainTransformer(transformers, sheet, this.rowProcessors, parentRow);
        return chainTransformer.transform(stc, this, beans);
    }

    private List parseCells(Sheet sheet, org.apache.poi.ss.usermodel.Row hssfRow, int startCell, int endCell, Map beans) {
        if (this.configuration.getRowKeyName() != null) {
            beans.put(this.configuration.getRowKeyName(), hssfRow);
        }
        ArrayList<BaseRowTransformer> transformers = new ArrayList<BaseRowTransformer>();
        BaseRowTransformer rowTransformer = null;
        Row row = new Row(sheet, hssfRow);
        SimpleRowTransformer simpleRowTransformer = new SimpleRowTransformer(row, this.cellProcessors, this.configuration);
        boolean hasCollections = false;
        if (startCell >= 0 && endCell >= 0) {
            for (int j = startCell; j <= endCell && j > -1; ++j) {
                CellParser cellParser;
                Cell cell;
                org.apache.poi.ss.usermodel.Cell hssfCell = hssfRow.getCell(j);
                if (this.configuration.getCellKeyName() != null) {
                    beans.put(this.configuration.getCellKeyName(), hssfCell);
                }
                if ((cell = (cellParser = new CellParser(hssfCell, row, this.configuration)).parseCell(beans)).getTag() == null) {
                    if (cell.getLabel() != null && cell.getLabel().length() > 0) {
                        sheet.addNamedCell(cell.getLabel(), cell);
                    }
                    RowCollection rowCollection = row.addCell(cell);
                    if (cell.getCollectionProperty() != null) {
                        hasCollections = true;
                        if (rowTransformer == null) {
                            rowTransformer = new CollectionRowTransformer(row, this.fixedSizeCollections, this.cellProcessors, this.rowProcessors, this.configuration);
                            transformers.add(rowTransformer);
                        }
                        ((CollectionRowTransformer)rowTransformer).addRowCollection(rowCollection);
                        ListRange listRange = new ListRange(row.getPoiRow().getRowNum(), row.getPoiRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size() - 1, j);
                        this.addListRange(sheet, cell.getCollectionProperty().getProperty(), listRange);
                        continue;
                    }
                    if (cell.isEmpty()) continue;
                    simpleRowTransformer.addCell(cell);
                    continue;
                }
                rowTransformer = new TagRowTransformer(row, cell);
                Block tagBody = cell.getTag().getTagContext().getTagBody();
                j += tagBody.getNumberOfColumns() - 1;
                transformers.add(rowTransformer);
            }
        }
        if (!hasCollections && simpleRowTransformer.getCells().size() > 0) {
            transformers.add(simpleRowTransformer);
        }
        for (int i = 0; i < row.getCells().size(); ++i) {
            Cell cell = (Cell)row.getCells().get(i);
            if (cell.getTag() != null) continue;
            if (cell.getRowCollection() == null && cell.getCollectionName() != null) {
                RowCollection rowCollection = row.getRowCollectionByCollectionName(cell.getCollectionName());
                if (rowCollection != null) {
                    rowCollection.addCell(cell);
                } else {
                    log.debug((Object)("RowCollection with name " + cell.getCollectionName() + " not found"));
                }
            } else if (cell.isEmpty() && cell.getRowCollection() == null && cell.getMergedRegion() == null && row.getRowCollections().size() == 1) {
                ((RowCollection)row.getRowCollections().get(0)).addCell(cell);
            }
            if (!cell.isFormula() || !cell.getFormula().isInline() || cell.getLabel() == null || cell.getLabel().length() <= 0) continue;
            ListRange listRange = new ListRange(row.getPoiRow().getRowNum(), row.getPoiRow().getRowNum() + cell.getRowCollection().getCollectionProperty().getCollection().size() - 1, cell.getPoiCell().getColumnIndex());
            this.addListRange(sheet, cell.getLabel(), listRange);
        }
        return transformers;
    }

    List parseRow(Sheet sheet, org.apache.poi.ss.usermodel.Row hssfRow, Map beans) {
        List transformers = this.parseCells(sheet, hssfRow, hssfRow.getFirstCellNum(), hssfRow.getLastCellNum(), beans);
        return transformers;
    }

    private boolean addListRange(Sheet sheet, String rangeName, ListRange range) {
        if (sheet.getListRanges().containsKey(rangeName)) {
            sheet.addListRange(rangeName, range);
            return true;
        }
        sheet.addListRange(rangeName, range);
        return false;
    }

    private void applyRowProcessors(Sheet sheet, Row row) {
        int c = this.rowProcessors.size();
        for (int i = 0; i < c; ++i) {
            RowProcessor rowProcessor = (RowProcessor)this.rowProcessors.get(i);
            rowProcessor.processRow(row, sheet.getNamedCells());
        }
    }

    void groupRows(Sheet sheet) {
        for (String collectionName : this.groupedCollections) {
            if (!sheet.getListRanges().containsKey(collectionName)) continue;
            ListRange listRange = (ListRange)sheet.getListRanges().get(collectionName);
            sheet.getPoiSheet().groupRow(listRange.getFirstRowNum(), listRange.getLastRowNum());
        }
    }
}

