/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.core.utils;

import fr.opensagres.xdocreport.core.internal.IXMLPrettyPrinter;
import fr.opensagres.xdocreport.core.internal.IndentNumberPrettyPrinter;
import fr.opensagres.xdocreport.core.internal.NoIndentNumberPrettyPrinter;
import fr.opensagres.xdocreport.core.internal.NoPrettyPrinter;
import fr.opensagres.xdocreport.core.internal.XSLTPrettyPrinter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class XMLUtils {
    public static final Integer INDENT_NUMBER = new Integer(4);
    public static final List<IXMLPrettyPrinter> PRINTERS;
    private static IXMLPrettyPrinter wellPrinter;

    public static String prettyPrint(String xml) {
        return XMLUtils.prettyPrint(xml, INDENT_NUMBER);
    }

    public static String prettyPrint(String xml, int indent) {
        if (wellPrinter == null) {
            for (IXMLPrettyPrinter printer : PRINTERS) {
                try {
                    String result = printer.prettyPrint(xml, indent);
                    wellPrinter = printer;
                    return result;
                }
                catch (Throwable e) {
                }
            }
            return xml;
        }
        try {
            return wellPrinter.prettyPrint(xml, indent);
        }
        catch (Throwable e) {
            return xml;
        }
    }

    public static AttributesImpl toAttributesImpl(Attributes attributes) {
        if (attributes instanceof AttributesImpl) {
            return (AttributesImpl)attributes;
        }
        AttributesImpl attributesImpl = new AttributesImpl();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            attributesImpl.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
        }
        return attributesImpl;
    }

    static {
        wellPrinter = null;
        PRINTERS = new ArrayList<IXMLPrettyPrinter>();
        PRINTERS.add(IndentNumberPrettyPrinter.INSTANCE);
        PRINTERS.add(XSLTPrettyPrinter.INSTANCE);
        PRINTERS.add(NoIndentNumberPrettyPrinter.INSTANCE);
        PRINTERS.add(NoPrettyPrinter.INSTANCE);
    }
}

