/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import net.sf.jxls.exception.ParsePropertyException;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.parser.Expression;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Tag;
import net.sf.jxls.tag.TagContext;
import net.sf.jxls.transformer.Configuration;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Sheet;
import org.xml.sax.SAXException;

public class CellParser {
    protected static final Log log = LogFactory.getLog(CellParser.class);
    private final Cell cell;
    private Configuration configuration;

    public CellParser(org.apache.poi.ss.usermodel.Cell hssfCell, Row row, Configuration configuration) {
        this.cell = new Cell(hssfCell, row);
        this.configuration = configuration != null ? configuration : new Configuration();
    }

    public CellParser(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public Cell parseCell(Map beans) {
        org.apache.poi.ss.usermodel.Cell c = this.cell.getPoiCell();
        if (c != null) {
            try {
                if (c.getCellType() == 1) {
                    this.cell.setPoiCellValue(c.getRichStringCellValue().getString());
                    this.parseCellValue(beans);
                }
            }
            catch (ParsePropertyException e) {
                log.error((Object)("Can't get value for property=" + this.cell.getCollectionProperty().getProperty()), (Throwable)e);
                throw new RuntimeException(e);
            }
            this.updateMergedRegions();
        }
        return this.cell;
    }

    public Formula parseCellFormula() {
        if (this.cell.getPoiCell() != null && this.cell.getPoiCell().getCellType() == 1) {
            this.cell.setPoiCellValue(this.cell.getPoiCell().getRichStringCellValue().getString());
            if (this.cell.getPoiCellValue().startsWith(this.configuration.getStartFormulaToken()) && this.cell.getPoiCellValue().lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            }
        }
        return this.cell.getFormula();
    }

    private void parseFormula() {
        String poiCellValue = this.cell.getPoiCellValue();
        int i = poiCellValue.lastIndexOf(this.configuration.getEndFormulaToken());
        String expr = poiCellValue.substring(2, i);
        this.cell.setFormula(new Formula(expr, this.cell.getRow().getSheet()));
        this.cell.getFormula().setRowNum(this.cell.getRow().getPoiRow().getRowNum());
        this.cell.getFormula().setCellNum(this.cell.getPoiCell().getColumnIndex());
        if (i + 1 < poiCellValue.length()) {
            String tail = poiCellValue.substring(i + 1);
            int j = tail.indexOf(this.configuration.getMetaInfoToken());
            if (j >= 0) {
                this.cell.setMetaInfo(tail.substring(j));
                if (j > 0) {
                    this.cell.setLabel(tail.substring(0, j));
                }
                this.cell.setCollectionName(tail.substring(j + 2));
            } else {
                this.cell.setLabel(tail);
            }
        }
        this.cell.setStringCellValue(poiCellValue.substring(0, i + 1));
    }

    private void parseCellExpression(Map beans) {
        int k;
        String curValue;
        this.cell.setCollectionProperty(null);
        String cv = curValue = this.cell.getPoiCellValue();
        int depRowNum = 0;
        int j = curValue.lastIndexOf(this.configuration.getMetaInfoToken());
        if (j >= 0) {
            this.cell.setStringCellValue(cv.substring(0, j));
            this.cell.setMetaInfo(cv.substring(j + 2));
            String tail = curValue.substring(j + 2);
            k = tail.indexOf(":");
            if (k >= 0) {
                try {
                    depRowNum = Integer.parseInt(tail.substring(k + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                this.cell.setCollectionName(tail.substring(0, k));
            } else {
                this.cell.setCollectionName(tail);
            }
            curValue = curValue.substring(0, j);
        } else {
            this.cell.setStringCellValue(cv);
        }
        try {
            while (curValue.length() > 0) {
                int i = curValue.indexOf(this.configuration.getStartExpressionToken());
                if (i >= 0) {
                    k = curValue.indexOf(this.configuration.getEndExpressionToken(), i + 2);
                    if (k >= 0) {
                        Expression expression;
                        String expr = curValue.substring(i + 2, k);
                        if (i > 0) {
                            String before = curValue.substring(0, i);
                            this.cell.getExpressions().add(new Expression(before, this.configuration));
                        }
                        if ((expression = new Expression(expr, beans, this.configuration)).getCollectionProperty() != null) {
                            if (this.cell.getCollectionProperty() == null) {
                                this.cell.setCollectionName(expression.getCollectionProperty().getFullCollectionName());
                                this.cell.setCollectionProperty(expression.getCollectionProperty());
                                this.cell.setDependentRowNumber(depRowNum);
                            } else if (log.isInfoEnabled()) {
                                log.info((Object)"Only the same collection property in a cell is allowed.");
                            }
                        }
                        this.cell.getExpressions().add(expression);
                        curValue = curValue.substring(k + 1, curValue.length());
                        continue;
                    }
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                    curValue = "";
                    continue;
                }
                if (curValue.length() != cv.length()) {
                    this.cell.getExpressions().add(new Expression(curValue, this.configuration));
                }
                curValue = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"Can't parse expression", (Throwable)e);
        }
    }

    private void parseCellValue(Map beans) throws ParsePropertyException {
        String cv = this.cell.getPoiCellValue();
        if (cv != null) {
            if (cv.startsWith(this.configuration.getStartFormulaToken()) && cv.lastIndexOf(this.configuration.getEndFormulaToken()) > 0) {
                this.parseFormula();
            } else if (cv.startsWith(this.configuration.getTagPrefixWithBrace())) {
                String tagName = this.getTagName(cv);
                if (tagName != null) {
                    Row row = this.cell.getRow();
                    org.apache.poi.ss.usermodel.Row poiRow = row.getPoiRow();
                    org.apache.poi.ss.usermodel.Cell poiCell = this.cell.getPoiCell();
                    int rowNum = poiRow.getRowNum();
                    int columnIndex = poiCell.getColumnIndex();
                    if (cv.endsWith("/>")) {
                        Block tagBody = new Block(rowNum, columnIndex, rowNum, columnIndex);
                        this.parseTag(tagName, tagBody, beans, false);
                    } else {
                        org.apache.poi.ss.usermodel.Cell hssfCell = this.findMatchingPairInRow(poiRow, tagName);
                        if (hssfCell != null) {
                            Block tagBody = new Block(rowNum, columnIndex, rowNum, hssfCell.getColumnIndex());
                            this.parseTag(tagName, tagBody, beans, true);
                        } else {
                            org.apache.poi.ss.usermodel.Row hssfRow = this.findMatchingPair(tagName);
                            if (hssfRow != null) {
                                int lastTagBodyRowNum = hssfRow.getRowNum();
                                Block tagBody = new Block(null, rowNum, lastTagBodyRowNum);
                                this.parseTag(tagName, tagBody, beans, true);
                            } else {
                                log.error((Object)("Can't find matching tag pair for " + cv));
                            }
                        }
                    }
                }
            } else {
                this.parseCellExpression(beans);
            }
        }
    }

    private org.apache.poi.ss.usermodel.Cell findMatchingPairInRow(org.apache.poi.ss.usermodel.Row hssfRow, String tagName) {
        int count = 0;
        if (hssfRow != null) {
            for (int j = this.cell.getPoiCell().getColumnIndex() + 1; j <= hssfRow.getLastCellNum(); ++j) {
                org.apache.poi.ss.usermodel.Cell hssfCell = hssfRow.getCell(j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getRichStringCellValue().getString();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfCell;
                }
                --count;
            }
        }
        return null;
    }

    private String getTagName(String xmlTag) {
        int i;
        int j;
        for (j = i = this.configuration.getTagPrefix().length() + 1; j < xmlTag.length() && Character.isLetterOrDigit(xmlTag.charAt(j)); ++j) {
        }
        if (j == xmlTag.length()) {
            log.warn((Object)"can't determine tag name");
            return null;
        }
        return xmlTag.substring(i, j);
    }

    private org.apache.poi.ss.usermodel.Row findMatchingPair(String tagName) {
        Sheet hssfSheet = this.cell.getRow().getSheet().getPoiSheet();
        int count = 0;
        for (int i = this.cell.getRow().getPoiRow().getRowNum() + 1; i <= hssfSheet.getLastRowNum(); ++i) {
            org.apache.poi.ss.usermodel.Row hssfRow = hssfSheet.getRow(i);
            if (hssfRow == null || hssfRow.getFirstCellNum() < 0 || hssfRow.getLastCellNum() < 0) continue;
            for (short j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); j = (short)(j + 1)) {
                org.apache.poi.ss.usermodel.Cell hssfCell = hssfRow.getCell((int)j);
                if (hssfCell == null || hssfCell.getCellType() != 1) continue;
                String cellValue = hssfCell.getRichStringCellValue().getString();
                if (cellValue.matches("<" + this.configuration.getTagPrefix() + tagName + "\\b.*")) {
                    ++count;
                    continue;
                }
                if (!cellValue.matches("</" + this.configuration.getTagPrefix() + tagName + ">")) continue;
                if (count == 0) {
                    return hssfRow;
                }
                --count;
            }
        }
        return null;
    }

    private void parseTag(String tagName, Block tagBody, Map beans, boolean appendCloseTag) {
        String xml = null;
        try {
            Tag tag;
            xml = appendCloseTag ? this.configuration.getJXLSRoot() + this.cell.getPoiCellValue() + "</" + this.configuration.getTagPrefix() + tagName + ">" + this.configuration.getJXLSRootEnd() : this.configuration.getJXLSRoot() + this.cell.getPoiCellValue() + this.configuration.getJXLSRootEnd();
            if (this.configuration.getEncodeXMLAttributes()) {
                xml = Util.escapeAttributes(xml);
            }
            if ((tag = (Tag)this.configuration.getDigester().parse((Reader)new StringReader(xml))) == null) {
                throw new RuntimeException("Invalid tag: " + tagName);
            }
            this.cell.setTag(tag);
            TagContext tagContext = new TagContext(this.cell.getRow().getSheet(), tagBody, beans);
            tag.init(tagContext);
        }
        catch (IOException e) {
            log.warn((Object)("Can't parse cell tag " + this.cell.getPoiCellValue() + ": fullXML: " + xml), (Throwable)e);
            throw new RuntimeException("Can't parse cell tag " + this.cell.getPoiCellValue() + ": fullXML: " + xml, e);
        }
        catch (SAXException e) {
            log.warn((Object)("Can't parse cell tag " + this.cell.getPoiCellValue() + ": fullXML: " + xml), (Throwable)e);
            throw new RuntimeException("Can't parse cell tag " + this.cell.getPoiCellValue() + ": fullXML: " + xml, e);
        }
    }

    private void updateMergedRegions() {
        Row row = this.cell.getRow();
        this.cell.setMergedRegion(Util.getMergedRegion(row.getSheet().getPoiSheet(), row.getPoiRow().getRowNum(), this.cell.getPoiCell().getColumnIndex()));
    }
}

