/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.template.listeners;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.template.api.TemplateProcessorService;
import org.nuxeo.template.api.adapters.TemplateBasedDocument;
import org.nuxeo.template.api.adapters.TemplateSourceDocument;

public class TemplateInitListener
implements EventListener {
    private static final Log log = LogFactory.getLog(TemplateInitListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (("aboutToCreate".equals(event.getName()) || "beforeDocumentModification".equals(event.getName())) && ctx instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel targetDoc = docCtx.getSourceDocument();
            if (targetDoc.isVersion()) {
                return;
            }
            TemplateSourceDocument templateDoc = (TemplateSourceDocument)targetDoc.getAdapter(TemplateSourceDocument.class);
            if (templateDoc != null) {
                templateDoc.initTypesBindings();
                List params = templateDoc.getParams();
                if (params == null || params.size() == 0 || this.isBlobDirty(targetDoc)) {
                    templateDoc.initTemplate(false);
                }
            } else {
                TemplateBasedDocument tmplBased = (TemplateBasedDocument)targetDoc.getAdapter(TemplateBasedDocument.class);
                if (tmplBased == null) {
                    List tuids;
                    TemplateProcessorService tps = (TemplateProcessorService)Framework.getService(TemplateProcessorService.class);
                    String targetTemplateUid = (String)((Object)targetDoc.getContextData("templateId"));
                    if ("none".equals(targetTemplateUid)) {
                        targetTemplateUid = null;
                    }
                    ArrayList<String> templatesUids = new ArrayList<String>();
                    if (targetTemplateUid != null) {
                        templatesUids.add(targetTemplateUid);
                    }
                    if ((tuids = (List)tps.getTypeMapping().get(targetDoc.getType())) != null) {
                        for (String tuid : tuids) {
                            if (templatesUids.contains(tuid)) continue;
                            templatesUids.add(tuid);
                        }
                    }
                    if (templatesUids.size() > 0) {
                        for (String tuid : templatesUids) {
                            DocumentModel sourceTemplateDoc;
                            IdRef templateRef = new IdRef(tuid);
                            if (!docCtx.getCoreSession().exists((DocumentRef)templateRef) || (sourceTemplateDoc = docCtx.getCoreSession().getDocument((DocumentRef)templateRef)).isTrashed()) continue;
                            tps.makeTemplateBasedDocument(targetDoc, sourceTemplateDoc, false);
                        }
                    }
                }
            }
        }
    }

    protected boolean isBlobDirty(DocumentModel targetDoc) {
        BlobHolder bh = (BlobHolder)targetDoc.getAdapter(BlobHolder.class);
        Blob mainBlob = bh.getBlob();
        return mainBlob != null && mainBlob.getDigest() == null;
    }
}

