/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.thumbnail.ext;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.thumbnail.factories.ThumbnailDocumentFactory;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.runtime.api.Framework;

public class DocumentThumbnailExtFactory
extends ThumbnailDocumentFactory {
    private static final Log log = LogFactory.getLog(DocumentThumbnailExtFactory.class);
    public static final String THUMBNAIL_FORMAT = "image/png";

    public Blob computeThumbnail(DocumentModel doc, CoreSession session) {
        ConversionService conversionService = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
        if (bh != null && bh.getBlob() != null) {
            Blob blob = bh.getBlob();
            List converterNames = conversionService.getConverterNames(blob.getMimeType(), THUMBNAIL_FORMAT);
            if (converterNames.contains("anyToThumbnail")) {
                return super.computeThumbnail(doc, session);
            }
            if (!converterNames.isEmpty()) {
                BlobHolder converted = conversionService.convert((String)converterNames.get(0), (BlobHolder)new SimpleBlobHolder(blob), new HashMap());
                return converted.getBlob();
            }
            log.warn((Object)String.format("%s converter doesn't support %s", "anyToThumbnail", blob.getMimeType()));
        }
        return null;
    }

    protected Blob getDefaultThumbnail(DocumentModel doc) {
        if (doc != null) {
            String iconPath;
            if (doc.hasSchema("common") && StringUtils.isNotBlank((CharSequence)((String)((Object)doc.getPropertyValue("common:icon"))))) {
                iconPath = (String)((Object)doc.getPropertyValue("common:icon"));
            } else {
                TypeInfo docType = (TypeInfo)doc.getAdapter(TypeInfo.class);
                iconPath = docType.getBigIcon();
                if (iconPath == null) {
                    iconPath = docType.getIcon();
                }
            }
            if (iconPath != null) {
                try {
                    File iconFile = FileUtils.getResourceFileFromContext((String)("nuxeo.war" + File.separator + iconPath));
                    if (iconFile != null && iconFile.exists()) {
                        MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
                        String mimeType = mimetypeRegistry.getMimetypeFromFile(iconFile);
                        if (mimeType == null) {
                            mimeType = mimetypeRegistry.getMimetypeFromFilename(iconPath);
                        }
                        return Blobs.createBlob((File)iconFile, (String)mimeType);
                    }
                }
                catch (IOException e) {
                    log.warn((Object)String.format("Could not fetch the thumbnail blob from icon path '%s'", iconPath), (Throwable)e);
                }
            }
        }
        return null;
    }
}

