Prism.languages.livescript = {
	'interpolated-string': {
		pattern: /("""|")(?:\\[\s\S]|(?!\1)[^\\])*\1/,
		greedy: true,
		inside: {
			'variable': {
				pattern: /(^|[^\\])#[a-z_](?:-?[a-z]|\d)*/m,
				lookbehind: true
			},
			'interpolation': {
				pattern: /(^|[^\\])#\{[^}]+\}/m,
				lookbehind: true,
				inside: {
					'interpolation-punctuation': {
						pattern: /^#\{|\}$/,
						alias: 'variable'
					}
					// See rest below
				}
			},
			'string': /[\s\S]+/
		}
	},
	'comment': [
		{
			pattern: /(^|[^\\])\/\*[\w\W]*?\*\//,
			lookbehind: true,
			greedy: true
		},
		{
			pattern: /(^|[^\\])#.*/,
			lookbehind: true,
			greedy: true
		}
	],
	'string': [
		{
			pattern: /('''|')(?:\\[\s\S]|(?!\1)[^\\])*\1/,
			greedy: true
		},
		{
			pattern: /<\[[\s\S]*?\]>/,
			greedy: true
		},
		/\\[^\s,;\])}]+/
	],
	'regex': [
		{
			pattern: /\/\/(\[.+?]|\\.|(?!\/\/)[^\\])+\/\/[gimyu]{0,5}/,
			greedy: true,
			inside: {
				'comment': {
					pattern: /(^|[^\\])#.*/,
					lookbehind: true
				}
			}
		},
		{
			pattern: /\/(\[.+?]|\\.|[^/\\\r\n])+\/[gimyu]{0,5}/,
			greedy: true
		}
	],
	'keyword': {
		pattern: /(^|(?!-).)\b(?:break|case|catch|class|const|continue|default|do|else|extends|fallthrough|finally|for(?: ever)?|function|if|implements|it|let|loop|new|null|otherwise|own|return|super|switch|that|then|this|throw|try|unless|until|var|void|when|while|yield)(?!-)\b/m,
		lookbehind: true
	},
	'keyword-operator': {
		pattern: /(^|[^-])\b(?:(?:delete|require|typeof)!|(?:and|by|delete|export|from|import(?: all)?|in|instanceof|is(?:nt| not)?|not|of|or|til|to|typeof|with|xor)(?!-)\b)/m,
		lookbehind: true,
		alias: 'operator'
	},
	'boolean': {
		pattern: /(^|[^-])\b(?:false|no|off|on|true|yes)(?!-)\b/m,
		lookbehind: true
	},
	'argument': {
		// Don't match .&. nor &&
		pattern: /(^|(?!\.&\.)[^&])&(?!&)\d*/m,
		lookbehind: true,
		alias: 'variable'
	},
	'number': /\b(?:\d+~[\da-z]+|\d[\d_]*(?:\.\d[\d_]*)?(?:[a-z]\w*)?)/i,
	'identifier': /[a-z_](?:-?[a-z]|\d)*/i,
	'operator': [
		// Spaced .
		{
			pattern: /( )\.(?= )/,
			lookbehind: true
		},
		// Full list, in order:
		// .= .~ .. ...
		// .&. .^. .<<. .>>. .>>>.
		// := :: ::=
		// &&
		// || |>
		// < << <<< <<<<
		// <- <-- <-! <--!
		// <~ <~~ <~! <~~!
		// <| <= <?
		// > >> >= >?
		// - -- -> -->
		// + ++
		// @ @@
		// % %%
		// * **
		// ! != !~=
		// !~> !~~>
		// !-> !-->
		// ~ ~> ~~> ~=
		// = ==
		// ^ ^^
		// / ?
		/\.(?:[=~]|\.\.?)|\.(?:[&|^]|<<|>>>?)\.|:(?:=|:=?)|&&|\|[|>]|<(?:<<?<?|--?!?|~~?!?|[|=?])?|>[>=?]?|-(?:->?|>)?|\+\+?|@@?|%%?|\*\*?|!(?:~?=|--?>|~?~>)?|~(?:~?>|=)?|==?|\^\^?|[\/?]/
	],
	'punctuation': /[(){}\[\]|.,:;`]/
};

Prism.languages.livescript['interpolated-string'].inside['interpolation'].inside.rest = Prism.languages.livescript;