/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.cleanup.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.cleanup.TrashCleanUpConstant;
import org.nuxeo.ecm.platform.cleanup.service.TrashCleanUp;
import org.nuxeo.ecm.platform.cleanup.work.TrashCleanUpWork;
import org.nuxeo.runtime.api.Framework;

public class TrashCleanUpListener
implements EventListener {
    protected static final Log log = LogFactory.getLog(TrashCleanUpListener.class);

    public void handleEvent(Event event) {
        log.info((Object)"Trash Clean Up Event triggered");
        TrashCleanUp trashCleanUp = (TrashCleanUp)Framework.getService(TrashCleanUp.class);
        if (trashCleanUp.useWorkers().booleanValue()) {
            log.info((Object)"Trash Clean Up Event with Workers");
            ((WorkManager)Framework.getService(WorkManager.class)).schedule((Work)new TrashCleanUpWork(), WorkManager.Scheduling.IF_NOT_SCHEDULED, true);
        } else {
            log.info((Object)"Trash Clean Up Event with BAF");
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            RepositoryService repositoryService = (RepositoryService)Framework.getService(RepositoryService.class);
            for (String repositoryName : repositoryService.getRepositoryNames()) {
                BulkCommand command = new BulkCommand.Builder("cleanUpTrash", TrashCleanUpConstant.QUERY).user("system").repository(repositoryName).build();
                bulkService.submit(command);
            }
        }
    }
}

