/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.cleanup.service;

import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.query.sql.model.OrderByExprs;
import org.nuxeo.ecm.core.query.sql.model.Predicates;
import org.nuxeo.ecm.core.query.sql.model.QueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditQueryBuilder;
import org.nuxeo.ecm.platform.audit.api.AuditReader;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.cleanup.service.TrashCleanUp;
import org.nuxeo.ecm.platform.cleanup.service.extension.TrashCleanUpConfigDescriptor;
import org.nuxeo.ecm.platform.cleanup.utils.DateUtils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class TrashCleanUpImpl
extends DefaultComponent
implements TrashCleanUp {
    protected static final Log log = LogFactory.getLog(TrashCleanUp.class);
    private static final String DOC_UUID = "docUUID";
    private static final String EVENT_ID = "eventId";
    private static final String DOCUMENT_TRASHED = "documentTrashed";
    private static final String EVENT_DATE = "eventDate";
    public static final String TRASH_CLEAN_UP_EP = "trashcleanup";
    protected TrashCleanUpConfigDescriptor trashCleanUpConfigDescriptor;
    public Function<LogEntry, LocalDateTime> DATE_WITH_ADDED_CONTRIB_VALUES = x -> {
        Calendar logDate = Calendar.getInstance();
        logDate.setTime(x.getLogDate());
        logDate.add(1, this.getYears());
        logDate.add(2, this.getMonths());
        logDate.add(5, this.getDays());
        logDate.add(10, this.getHours());
        logDate.add(12, this.getMinutes());
        logDate.add(13, this.getSeconds());
        return DateUtils.toLocalDateTime(logDate);
    };

    public void activate(ComponentContext context) {
        this.trashCleanUpConfigDescriptor = new TrashCleanUpConfigDescriptor();
    }

    public void deactivate(ComponentContext context) {
        this.trashCleanUpConfigDescriptor = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (TRASH_CLEAN_UP_EP.equals(extensionPoint)) {
            this.trashCleanUpConfigDescriptor = (TrashCleanUpConfigDescriptor)contribution;
        } else {
            log.error((Object)("Unable to handle unknown extensionPoint " + extensionPoint));
        }
    }

    @Override
    public Boolean useWorkers() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getUseWorker()).orElse(Boolean.FALSE);
    }

    @Override
    public void cleanUp(List<String> ids, CoreSession session) {
        AuditReader reader = (AuditReader)Framework.getService(AuditReader.class);
        log.info((Object)("Start trying to delete: [" + ids + "]"));
        ids.forEach(id -> {
            log.info((Object)("Start trying to delete: [" + id + "]"));
            QueryBuilder builder = new AuditQueryBuilder().predicate(Predicates.eq((String)DOC_UUID, (Object)id)).and(Predicates.eq((String)EVENT_ID, (Object)DOCUMENT_TRASHED)).order(OrderByExprs.desc((String)EVENT_DATE));
            reader.queryLogs(builder).stream().findFirst().filter(x -> this.DATE_WITH_ADDED_CONTRIB_VALUES.apply((LogEntry)x).isBefore(LocalDateTime.now())).map(LogEntry::getDocUUID).map(IdRef::new).filter(arg_0 -> ((CoreSession)session).exists(arg_0)).filter(arg_0 -> ((CoreSession)session).isTrashed(arg_0)).ifPresent(refDoc -> {
                try {
                    session.removeDocument((DocumentRef)refDoc);
                }
                catch (NuxeoException ex) {
                    log.error((Object)("The document referenced as: " + refDoc + " could not be deleted."), (Throwable)ex);
                }
            });
            log.info((Object)("Finished deleting: [" + id + "]"));
        });
        session.save();
    }

    protected Integer getDays() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getDays()).orElse(0);
    }

    protected Integer getMonths() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getMonths()).orElse(0);
    }

    protected Integer getSeconds() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getSeconds()).orElse(0);
    }

    protected Integer getYears() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getYears()).orElse(0);
    }

    protected Integer getHours() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getHours()).orElse(0);
    }

    protected Integer getMinutes() {
        return Optional.ofNullable(this.trashCleanUpConfigDescriptor.getMinutes()).orElse(0);
    }
}

