/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.cleanup.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;

public final class DateUtils {
    private DateUtils() throws IllegalAccessException {
        throw new IllegalAccessException("This class cannot be instantiated.");
    }

    public static String toQueryFormat(LocalDate today) {
        return today.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static Calendar toCalendar(LocalDate today) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(today.getYear(), today.getMonthValue() - 1, today.getDayOfMonth());
        return calendar;
    }

    public static Calendar toCalendar(LocalDateTime today) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(today.getYear(), today.getMonthValue() - 1, today.getDayOfMonth(), today.getHour(), today.getMinute(), today.getSecond());
        return calendar;
    }

    public static LocalDate toLocalDate(Calendar calendar) {
        return LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    public static LocalDateTime toLocalDateTime(Calendar calendar) {
        return LocalDateTime.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(10), calendar.get(12), calendar.get(13));
    }

    public static boolean isAfterOrEqual(LocalDate reference, LocalDate toTest) {
        return reference.isAfter(toTest) || reference.isEqual(toTest);
    }
}

